/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.cimtools.utils;

public class CIMToolsException
extends Exception {
    public static final String CATEGORY_COMMON = "CIM Tools";
    public static final String CATEGORY_CIMCLASSBROWSER = "CIM Browser";
    public static final String CATEGORY_CIMCLASSACCESS = "CIM Client Access";
    private static final long serialVersionUID = 1L;
    private String category;
    private Exception actualexception;
    private int messagedlg_type;

    public CIMToolsException(String category, String message, Exception e) {
        super(message);
        this.category = category;
        this.actualexception = e;
        this.messagedlg_type = 1;
    }

    public String getCategory() {
        return this.category;
    }

    public int getMessageDialogType() {
        return this.messagedlg_type;
    }

    public Exception getActualException() {
        Exception e;
        if (this.actualexception != null && (e = this.actualexception) instanceof CIMToolsException) {
            return ((CIMToolsException)e).getActualException();
        }
        return this.actualexception;
    }

    public void setMessgeDialogType(int type) {
        this.messagedlg_type = type;
    }

    public static CIMToolsException createException(String category, String message, Exception e) {
        return new CIMToolsException(category, message, e);
    }

    public static CIMToolsException createCIMBrowserException(String message, Exception e) {
        return CIMToolsException.createException(CATEGORY_CIMCLASSBROWSER, message, e);
    }

    public static CIMToolsException createCIMClientAccessException(String message, Exception e) {
        return CIMToolsException.createException(CATEGORY_CIMCLASSACCESS, message, e);
    }

    public static CIMToolsException createCommonException(String message, Exception e) {
        return CIMToolsException.createException(CATEGORY_COMMON, message, e);
    }
}

