/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.peweb.PewebPanel;
import com.vmware.vide.utils.json.Json;
import com.vmware.vide.utils.local.VMWBConfig;
import com.vmware.vide.vmwbrepository.Artifact;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class CertsPanel
extends PewebPanel {
    public static final String LINK_PREFIX = "vide:peweb/certs";
    public static final String PANEL_UI_NAME = "Certifications";
    public static final String LINK_LIST_CERTS = "vide:peweb/certs/list";
    public static final String LINK_LIST_DESCR = "Certifications List";
    private static final String CERT_ARTIFACTS = "cert";
    private static final String CERT_ARTIFACTS_OPEN = "cert/open";
    public String LINK_REFRESH = "vide:peweb/certs/refresh";
    private boolean gotViblist = false;

    public boolean init() {
        super.init(PANEL_UI_NAME, "CERT");
        this.setListAllLinks(LINK_LIST_CERTS, LINK_LIST_DESCR);
        return true;
    }

    public boolean isLockedContent() {
        return true;
    }

    public String getHeader() {
        return PANEL_UI_NAME;
    }

    @Override
    public String getHeaderCommands(boolean isHome) {
        StringBuffer buffer = new StringBuffer();
        if (this.isLoggedIn() && this.currentPage.startsWith(LINK_LIST_CERTS)) {
            buffer.append("<a href=\"");
            buffer.append(this.LINK_REFRESH);
            buffer.append("\">");
            buffer.append("Refresh");
            buffer.append("</a>&nbsp;&nbsp;&nbsp;");
            return buffer.toString();
        }
        return null;
    }

    @Override
    protected String getMissingMessageFor(String packageTypeName) {
        String userName = this.getUserName();
        if (userName == null) {
            return "You must log in to access available " + packageTypeName + ".";
        }
        if (this.loginError != null) {
            return "Access was denied. Reason: \"" + this.loginError + "\". Please try again.";
        }
        if (this.connectError != null && !this.connectError.isEmpty()) {
            String msg = this.connectError;
            int indx = msg.indexOf("<BODY>");
            if (indx > 0) {
                msg = msg.substring(indx + 6);
            }
            if ((indx = msg.indexOf("</BODY>")) > 0) {
                msg = msg.substring(0, indx);
            }
            return "Could not get the list of " + packageTypeName + ". Reason: " + msg;
        }
        StringBuilder msg = new StringBuilder();
        msg.append("No ");
        msg.append(packageTypeName);
        msg.append(" available.");
        return msg.toString();
    }

    @Override
    public boolean handleActionClick(String location) {
        if (location.startsWith(this.LINK_REFRESH)) {
            this.setCredentials(this.getUserName(), this.getPassword());
            return true;
        }
        return super.handleActionClick(location);
    }

    @Override
    public String getPrefix() {
        return LINK_PREFIX;
    }

    @Override
    public String getHomeHtml() {
        if (this.isWorking()) {
            return super.getHomeHtml();
        }
        String user = this.getUserName();
        String password = this.getPassword();
        if (user == null) {
            this.gotViblist = false;
        } else if (!(user == null || user.isEmpty() || password == null || password.isEmpty() || this.gotViblist || this.connectError != null)) {
            block13: {
                BufferedWriter out = null;
                BufferedInputStream is = null;
                try {
                    String remoteViblist = this.webService.getTextualContent("/vmwb-repository/static/viblist.json");
                    if (remoteViblist != null) {
                        String path = String.valueOf(VMWBConfig.getInstallDir()) + "/opt/vmware/scripts/vibdc/resources/viblist.json";
                        is = new BufferedInputStream(new FileInputStream(new File(path)));
                        long oldVersion = this.getViblistVersion(is);
                        long newVersion = this.getViblistVersion(new ByteArrayInputStream(remoteViblist.getBytes()));
                        if (newVersion > oldVersion) {
                            out = new BufferedWriter(new FileWriter(path));
                            out.write(remoteViblist);
                            out.close();
                        }
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                    IOUtils.closeQuietly(is);
                    IOUtils.closeQuietly(out);
                    break block13;
                }
                catch (Exception e) {
                    try {
                        e.printStackTrace();
                        break block13;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        IOUtils.closeQuietly(is);
                        IOUtils.closeQuietly(out);
                    }
                }
                IOUtils.closeQuietly(is);
                IOUtils.closeQuietly(out);
            }
            this.gotViblist = true;
        }
        return super.getHomeHtml();
    }

    @Override
    public void setCredentials(String loginId, String password) {
        super.setCredentials(loginId, password);
        this.setChanged();
        this.notifyObservers("");
    }

    @Override
    protected List<Artifact> getArtifactsFromRepository() throws Exception {
        ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
        if (this.webService.getUserName() != null) {
            this.webService.getArtifacts(allArtifacts, CERT_ARTIFACTS);
        } else {
            this.webService.getArtifacts(allArtifacts, CERT_ARTIFACTS_OPEN);
        }
        return allArtifacts;
    }

    private long getViblistVersion(InputStream is) {
        try {
            Map map;
            Object versionObj;
            Object jsonRoot = Json.parse((InputStream)is);
            if (jsonRoot instanceof Map && (versionObj = (map = (Map)jsonRoot).get("version")) instanceof String) {
                return Long.parseLong((String)versionObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }
}

