/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.dashboard.peweb;

import com.vmware.vide.dashboard.PortalManager;
import java.lang.reflect.Field;
import java.net.URI;
import java.net.URISyntaxException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIActivator;
import org.eclipse.equinox.internal.p2.ui.dialogs.AvailableIUsPage;
import org.eclipse.equinox.internal.p2.ui.dialogs.InstallWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningOperationWizard;
import org.eclipse.equinox.internal.p2.ui.dialogs.ProvisioningWizardDialog;
import org.eclipse.equinox.internal.p2.ui.dialogs.RepositorySelectionGroup;
import org.eclipse.equinox.p2.operations.ProvisioningSession;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.wizard.IWizardPage;

public class InstallUtils {
    public static void addRepository(String url, String nickname) throws URISyntaxException {
        RepositoryTracker tracker;
        if (url == null || url.isEmpty()) {
            return;
        }
        ProvisioningUI pui = ProvisioningUI.getDefaultUI();
        if (pui != null && (tracker = pui.getRepositoryTracker()) != null) {
            tracker.addRepository(new URI(url), nickname, pui.getSession());
        }
    }

    public static void openInstallWizard(String url, boolean hasDependencies, IProgressMonitor monitor) throws URISyntaxException, SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        IDialogSettings settings;
        IDialogSettings section;
        URI location = new URI(url);
        ProvisioningUI pui = ProvisioningUI.getDefaultUI();
        if (hasDependencies && (section = (settings = ProvUIActivator.getDefault().getDialogSettings()).getSection("AvailableIUsPage")) != null) {
            String key = "ResolveInstallWithAllSites";
            section.put(key, true);
        }
        InstallWizard wizard = new InstallWizard(pui, null, null, null);
        ProvisioningWizardDialog dialog = new ProvisioningWizardDialog(ProvUI.getDefaultParentShell(), (ProvisioningOperationWizard)wizard);
        dialog.create();
        IWizardPage page = wizard.getPage("AvailableSoftwarePage");
        if (page instanceof AvailableIUsPage) {
            Object value;
            AvailableIUsPage iupage = (AvailableIUsPage)page;
            Class<?> c = iupage.getClass();
            Field field = c.getDeclaredField("repoSelector");
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((value = field.get(iupage)) instanceof RepositorySelectionGroup) {
                RepositorySelectionGroup group = (RepositorySelectionGroup)value;
                group.setRepositorySelection(4, location);
            }
            if (PortalManager.needDisableRepositories()) {
                URI[] currentlyEnabled;
                ProvisioningSession session = pui.getSession();
                IMetadataRepositoryManager metaManager = ProvUI.getMetadataRepositoryManager((ProvisioningSession)session);
                int visibilityFlags = pui.getRepositoryTracker().getMetadataRepositoryFlags();
                URI[] uRIArray = currentlyEnabled = metaManager.getKnownRepositories(visibilityFlags);
                int n = currentlyEnabled.length;
                int n2 = 0;
                while (n2 < n) {
                    block14: {
                        URI uri = uRIArray[n2];
                        String path = uri.getPath();
                        if (path == null) {
                            System.err.println("ERROR: uri has null path.  uri='" + uri.toString() + "'");
                        } else if (!path.contains("vmwb-repository")) {
                            pui.signalRepositoryOperationStart();
                            try {
                                try {
                                    metaManager.setEnabled(uri, false);
                                }
                                catch (Exception exception) {
                                    pui.signalRepositoryOperationComplete(null, true);
                                    break block14;
                                }
                            }
                            catch (Throwable throwable) {
                                pui.signalRepositoryOperationComplete(null, true);
                                throw throwable;
                            }
                            pui.signalRepositoryOperationComplete(null, true);
                        }
                    }
                    ++n2;
                }
            }
        }
        dialog.open();
    }
}

