/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core;

import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetManager;
import com.vmware.vide.target.api.TargetManagerPlugin;
import com.vmware.vide.utils.resource.ResourceUtils;
import com.vmware.vide.vlogbrowser.core.ILogBrowserManager;
import com.vmware.vide.vlogbrowser.core.fileops.BundleInfoManager;
import com.vmware.vide.vlogbrowser.core.fileops.LogFileManager;
import com.vmware.vide.vlogbrowser.core.model.LocationAndFilePattern;
import com.vmware.vide.vlogbrowser.core.model.LogSystemType;
import com.vmware.vide.vlogbrowser.core.model.LogxFile;
import com.vmware.vide.vlogbrowser.core.parser.ConfigParser;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLogBrowserManager
implements ILogBrowserManager {
    private static final Logger logger = LoggerFactory.getLogger(AbstractLogBrowserManager.class);
    protected Vector<LogxFile> logxTemplates = new Vector();
    protected List<File> logxTemplateFiles;
    protected Map<String, String> hostType = new HashMap<String, String>();
    protected Map<String, LogxFile[]> allFormats = new HashMap<String, LogxFile[]>();
    protected Map<String, LogxFile[]> absolutePathFormats = new HashMap<String, LogxFile[]>();
    protected String[] fCustomTemplateDirs = new String[0];
    protected String fRecentHost;
    protected Map<String, String> fRecentHostDirs = new HashMap<String, String>();
    protected Map<String, String> fRecentHostFormats = new HashMap<String, String>();

    @Override
    public String[] getCustomTemplateDirs() {
        return this.fCustomTemplateDirs;
    }

    @Override
    public void setCustomTemplateDirs(String[] dirs) {
        this.fCustomTemplateDirs = dirs;
        this.logxTemplateFiles = null;
        this.logxTemplates.clear();
        this.absolutePathFormats.clear();
        this.allFormats.clear();
    }

    @Override
    public void setRecentHostDir(String hostname, String lastDirectory) {
        this.fRecentHostDirs.put(hostname, lastDirectory);
    }

    @Override
    public String getRecentHostDir(String hostname) {
        String value = this.fRecentHostDirs.get(hostname);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public void setRecentHostFormat(String hostname, String lastDirectory) {
        this.fRecentHostFormats.put(hostname, lastDirectory);
    }

    @Override
    public String getRecentHostFormat(String hostname) {
        String value = this.fRecentHostFormats.get(hostname);
        if (value == null) {
            value = "";
        }
        return value;
    }

    @Override
    public String getRecentHost() {
        return this.fRecentHost;
    }

    @Override
    public void setRecentHost(String recentHost) {
        this.fRecentHost = recentHost;
    }

    protected abstract String getSpecificESXType(ITarget var1);

    @Override
    public String getHostType(ITarget target, boolean retryOnError) {
        String connectionName = target.getName();
        String savedType = this.hostType.get(connectionName);
        if (savedType == null || savedType.equals("Error contacting host") && retryOnError) {
            String targetType = target.getTargetType();
            savedType = targetType.equals("esx") ? this.getSpecificESXType(target) : (targetType.equals("linux") ? "Linux SSH" : (targetType.equals("localhost") ? "Local Filesystem" : (targetType.equals("vcva") ? "VCVA" : (targetType.equals("vc") ? "VC" : (targetType.equals("windows") ? "Windows" : target.getLabel())))));
            this.hostType.put(connectionName, savedType);
            this.absolutePathFormats.put(connectionName, null);
            this.allFormats.put(connectionName, null);
        }
        return savedType;
    }

    protected File[] getFilesInDirectory(String path, final String extension) throws Exception {
        File file;
        if (path != null && (file = new File(path)).exists() && file.isDirectory()) {
            return file.listFiles(new FileFilter(){

                @Override
                public boolean accept(File path) {
                    return path.isFile() && path.getName().endsWith(extension);
                }
            });
        }
        return new File[0];
    }

    protected File[] getUserTemplates() throws Exception, MalformedURLException {
        ArrayList<File> userTemplates = new ArrayList<File>();
        String[] dirs = this.fCustomTemplateDirs;
        if (dirs != null) {
            int i = 0;
            while (i < dirs.length) {
                String dir = dirs[i];
                File[] files = this.getFilesInDirectory(dir, ".logx");
                int j = 0;
                while (j < files.length) {
                    File file = files[j];
                    if (!userTemplates.contains(file)) {
                        userTemplates.add(file);
                    }
                    ++j;
                }
                ++i;
            }
        }
        File[] result = userTemplates.toArray(new File[0]);
        return result;
    }

    protected List<File> getTemplateFileListFromExtensionPoints() {
        ArrayList<File> additionalLogxFiles = new ArrayList<File>();
        IConfigurationElement[] configElementList = Platform.getExtensionRegistry().getConfigurationElementsFor("com.vmware.vide.vlogbrowser.core.logx.dir");
        try {
            IConfigurationElement[] iConfigurationElementArray = configElementList;
            int n = configElementList.length;
            int n2 = 0;
            while (n2 < n) {
                String pathValue;
                String bundleId;
                File logxSearchDir;
                IConfigurationElement configElement = iConfigurationElementArray[n2];
                String tagName = configElement.getName();
                if (tagName.equals("dir") && (logxSearchDir = ResourceUtils.getFileRelativeToBundle((String)(bundleId = configElement.getNamespaceIdentifier()), (String)(pathValue = configElement.getValue()))).exists() && logxSearchDir.isDirectory()) {
                    File[] logxFiles;
                    File[] fileArray = logxFiles = this.getFilesInDirectory(logxSearchDir.getAbsolutePath(), ".logx");
                    int n3 = logxFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File logxFile = fileArray[n4];
                        additionalLogxFiles.add(logxFile);
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            logger.error("Exception trying to get additional logx file directories from extension points: " + ex.getMessage(), (Throwable)ex);
        }
        return additionalLogxFiles;
    }

    protected List<File> getCompleteTemplateFileList() {
        if (this.logxTemplateFiles == null) {
            try {
                File f2;
                HashSet<String> logxFileNamesAdded = new HashSet<String>();
                URL dirURL = FileLocator.toFileURL((URL)AbstractLogBrowserManager.class.getResource("/templates/"));
                String dir = dirURL.getFile();
                File[] stdTemplates = this.getFilesInDirectory(dir, ".logx");
                List<File> pluginProvidedTemplates = this.getTemplateFileListFromExtensionPoints();
                File[] userTemplates = this.getUserTemplates();
                this.logxTemplateFiles = new ArrayList<File>(Arrays.asList(userTemplates));
                File[] fileArray = userTemplates;
                int n = userTemplates.length;
                int n2 = 0;
                while (n2 < n) {
                    f2 = fileArray[n2];
                    logxFileNamesAdded.add(f2.getName());
                    ++n2;
                }
                for (File f2 : pluginProvidedTemplates) {
                    if (logxFileNamesAdded.contains(f2.getName())) continue;
                    logxFileNamesAdded.add(f2.getName());
                    this.logxTemplateFiles.add(f2);
                }
                fileArray = stdTemplates;
                n = stdTemplates.length;
                int n3 = 0;
                while (n3 < n) {
                    f2 = fileArray[n3];
                    if (!logxFileNamesAdded.contains(f2.getName())) {
                        logxFileNamesAdded.add(f2.getName());
                        this.logxTemplateFiles.add(f2);
                    }
                    ++n3;
                }
            }
            catch (Exception e) {
                logger.error("Exception trying to get complete logx template file list: " + e.getMessage(), (Throwable)e);
            }
        }
        return this.logxTemplateFiles;
    }

    protected void parseLogxTemplates() throws Exception {
        List<File> logFormatFiles = this.getCompleteTemplateFileList();
        for (File file : logFormatFiles) {
            FileInputStream fstrm = new FileInputStream(file);
            ConfigParser cfgParser = new ConfigParser(fstrm);
            String logFormatName = cfgParser.getLogFormatName();
            String category = cfgParser.getCategory();
            boolean okFromSupportBundle = cfgParser.getOkFromSupportBundle();
            LogSystemType systemType = cfgParser.getSystemType();
            LogxFile template = new LogxFile(logFormatName, category, file.getAbsolutePath(), systemType, okFromSupportBundle);
            this.logxTemplates.add(template);
            ((InputStream)fstrm).close();
        }
    }

    @Override
    public boolean isShowAllTemplates(String hostname) {
        ITargetManager targetMgr = TargetManagerPlugin.getTheTargetManager();
        ITarget target = targetMgr.findTarget(hostname);
        if (target == null) {
            return false;
        }
        String targetType = target.getTargetType();
        String label = target.getLabel();
        return targetType.equals("localhost") || label != null && label.equals("SSH Only");
    }

    @Override
    public LogxFile[] getLogFormatsByHosttype(String hostType, String hostVer, boolean knownPathOnly) throws Exception {
        ArrayList<LogxFile> matchedTemplates = new ArrayList<LogxFile>();
        if (this.logxTemplates.isEmpty()) {
            this.parseLogxTemplates();
        }
        int i = 0;
        while (i < this.logxTemplates.size()) {
            boolean verMatches;
            LogxFile template = this.logxTemplates.get(i);
            String system = template.getSystemType().getSystem();
            String version = template.getSystemType().getVersion();
            boolean sysMatches = system.length() == 0 || Pattern.matches(system.toLowerCase(), hostType.toLowerCase());
            boolean bl = verMatches = version.length() == 0 || hostVer.length() == 0 || Pattern.matches(version.toLowerCase(), hostVer.toLowerCase());
            if (sysMatches && verMatches) {
                String[] locations;
                boolean absolutePath = false;
                String[] stringArray = locations = template.getSystemType().getDir().split("|");
                int n = locations.length;
                int n2 = 0;
                while (n2 < n) {
                    String location = stringArray[n2];
                    if (location.startsWith("/") || location.startsWith(":\\", 1)) {
                        absolutePath = true;
                        break;
                    }
                    ++n2;
                }
                if (!knownPathOnly || absolutePath) {
                    matchedTemplates.add(template);
                }
            }
            ++i;
        }
        LogxFile[] result = matchedTemplates.toArray(new LogxFile[0]);
        return result;
    }

    @Override
    public List<LogFormat> getLogFormats() throws Exception {
        ArrayList<LogFormat> logFormats = new ArrayList<LogFormat>(10);
        List<File> logFormatFiles = this.getCompleteTemplateFileList();
        for (File file : logFormatFiles) {
            FileInputStream fstrm = new FileInputStream(file);
            ConfigParser cfgParser = new ConfigParser(fstrm);
            logFormats.add(cfgParser.getLogFormat());
            ((InputStream)fstrm).close();
        }
        return logFormats;
    }

    @Override
    public File getLogxTemplateFile(String name, String version) throws Exception {
        if (this.logxTemplates.isEmpty()) {
            this.parseLogxTemplates();
        }
        int i = 0;
        while (i < this.logxTemplates.size()) {
            boolean versionMatch;
            LogxFile template = this.logxTemplates.get(i);
            String templateName = template.getLogFormatName();
            boolean nameMatch = name != null && name.compareToIgnoreCase(templateName) == 0;
            String templateVersion = template.getSystemType().getVersion();
            boolean bl = versionMatch = version.length() == 0 || templateVersion.length() == 0 || Pattern.matches(templateVersion.toLowerCase(), version.toLowerCase());
            if (nameMatch && versionMatch) {
                String path = template.getTemplateFilePath();
                File f = new File(path);
                return f;
            }
            ++i;
        }
        return null;
    }

    @Override
    public void clearHostFormats(String host) {
        this.allFormats.remove(host);
        this.absolutePathFormats.remove(host);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public LogSystemType getArchiveFileType(String host, String archiveFilePath, IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        archiveExtension = null;
        if (archiveFilePath != null && (archiveExtension = FilenameUtils.getExtension((String)archiveFilePath)) != null) {
            archiveExtension = archiveExtension.toLowerCase();
        }
        bundleInfoManager = BundleInfoManager.getInstance();
        bundleInfos = bundleInfoManager.getBundleInfoList();
        monitor.beginTask("", 20);
        hostname = host;
        try {
            allBundleFileLocations = bundleInfoManager.getAllBundleLocations();
            listOfLocationAndPattern = new ArrayList<LocationAndFilePattern>(allBundleFileLocations.size());
            listOfLocationAndPattern.addAll(allBundleFileLocations);
            if (listOfLocationAndPattern.size() == 0) {
                AbstractLogBrowserManager.logger.error("There are no LocationAndFilePattern entries extracted from bundle-patterns.xml to check in the bundle.  Something is wrong with this host/package.");
            }
            map = LogFileManager.getMatchingFiles(host, archiveFilePath, listOfLocationAndPattern, true, (IProgressMonitor)new SubProgressMonitor(monitor, 18));
            keySet = map.keySet();
            matchingLfpSet = new HashSet<LocationAndFilePattern>(keySet.size());
            monitor.setTaskName("Scanning log bundle to determine its type...");
            var14_14 = keySet.iterator();
            while (true) {
                if (!var14_14.hasNext()) {
                    if (matchingLfpSet.size() == 0) {
                        AbstractLogBrowserManager.logger.warn("Note that there are NO matching files from the set of files in archive {}", (Object)archiveFilePath);
                    }
                    subMonitor = new SubProgressMonitor(monitor, 2);
                    ** try [egrp 1[TRYBLOCK] [0 : 276->832)] { 
lbl28:
                    // 1 sources

                    break;
                }
                key = var14_14.next();
                fileList = map.get(key);
                if (fileList == null || fileList.size() <= 0) continue;
                matchingLfpSet.add(key);
            }
            {
                subMonitor.beginTask("", bundleInfos.size());
                var15_16 = bundleInfos.iterator();
                ** GOTO lbl44
            }
lbl-1000:
            // 1 sources

            {
                catch (Throwable var26_31) {
                    subMonitor.done();
                    throw var26_31;
                }
lbl41:
                // 1 sources

                while (true) {
                    subMonitor.done();
                    return var27_30;
                }
lbl44:
                // 1 sources

                ** try [egrp 3[TRYBLOCK] [3 : 846->919)] { 
lbl-1000:
                // 4 sources

                {
                    ** while (var15_16.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    bi = var15_16.next();
                    subMonitor.worked(1);
                    if (archiveExtension != null && (fileExtensions = bi.getFileExtensions()) != null && fileExtensions.length > 0) {
                        extensionsChecked = 0;
                        extensionsThatMatch = 0;
                        var22_26 = fileExtensions;
                        var21_24 = fileExtensions.length;
                        var20_22 = 0;
                        while (var20_22 < var21_24) {
                            extension = var22_26[var20_22];
                            if (!(extension = extension.trim().toLowerCase()).isEmpty()) {
                                ++extensionsChecked;
                            }
                            if (archiveExtension.equals(extension)) {
                                ++extensionsThatMatch;
                                break;
                            }
                            ++var20_22;
                        }
                        if (extensionsChecked != 0 && extensionsThatMatch == 0) {
                            AbstractLogBrowserManager.logger.info("{}:{} has an invalid file extension for type {} {}", (Object[])new String[]{host, archiveFilePath, bi.getSystemType(), bi.getVersion()});
                            continue;
                        }
                    }
                    if (!matchingLfpSet.containsAll(hasList = bi.getHasFileList())) {
                        AbstractLogBrowserManager.logger.info("{}:{} does not have all required logs of type {} {}", (Object[])new String[]{host, archiveFilePath, bi.getSystemType(), bi.getVersion()});
                        continue;
                    }
                    notCheckFailed = false;
                    notList = bi.getNotFileList();
                    for (LocationAndFilePattern lfp : notList) {
                        if (!matchingLfpSet.contains(lfp)) continue;
                        AbstractLogBrowserManager.logger.info("{}:{} contains '{}' precluding it from being type {} {}", (Object[])new String[]{host, archiveFilePath, lfp.getRegex(), bi.getSystemType(), bi.getVersion()});
                        notCheckFailed = true;
                        break;
                    }
                    if (notCheckFailed) continue;
                    hostFileLfp = bi.getHostFilePathFile();
                    if (hostFileLfp != null && (raFiles = map.get(hostFileLfp)).size() > 0) {
                        confFile = raFiles.get(0);
                        srcLogFilePath = confFile.getSrcFilePath();
                        p = Pattern.compile(bi.getHostFilePathValueRegex());
                        m = p.matcher(srcLogFilePath);
                        if (m.find() && (dotIndex = (hostname = m.group(bi.getHostFilePathRegexGroup())).indexOf(".")) > 0) {
                            hostname = hostname.substring(0, dotIndex);
                        }
                    }
                    AbstractLogBrowserManager.logger.info("{}:{} is bundle type {} {}", (Object[])new String[]{host, archiveFilePath, bi.getSystemType(), bi.getVersion()});
                    var27_30 = new LogSystemType(bi.getSystemType(), bi.getVersion(), hostname, "", "", false);
                    ** continue;
lbl88:
                    // 1 sources

                    ** GOTO lbl41
                }
lbl89:
                // 1 sources

                subMonitor.done();
                message = "The file '" + archiveFilePath + "' does not appear to be a valid log bundle.";
                AbstractLogBrowserManager.logger.info(message);
                throw new IllegalArgumentException(message);
            }
        }
lbl93:
        // 2 sources

        catch (Exception e) {
            AbstractLogBrowserManager.logger.error("Exception checking log bundles", (Throwable)e);
            throw new InvocationTargetException(e);
        }
        finally {
            monitor.done();
        }
    }
}

