/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.export;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public enum EnumLogExport {
    XML("*.xml", "xml file", "xml"),
    TXT("*.txt", "text file", "txt"),
    JSON("*.json", "json file", "json"),
    CSV("*.csv", "csv file", "csv");

    private String extension;
    private String description;
    private String option;
    public static final Map<String, EnumLogExport> OPTION_MAP;
    public static final Set<String> ALLOWABLE_OPTIONS;

    static {
        OPTION_MAP = new HashMap<String, EnumLogExport>();
        ALLOWABLE_OPTIONS = new HashSet<String>();
        int i = 0;
        while (i < EnumLogExport.values().length) {
            EnumLogExport e = EnumLogExport.values()[i];
            OPTION_MAP.put(e.option, EnumLogExport.values()[i]);
            ALLOWABLE_OPTIONS.add(e.option);
            ++i;
        }
    }

    private EnumLogExport(String extension, String description, String option) {
        this.extension = extension;
        this.description = description;
        this.option = option;
    }

    public String getExtension() {
        return this.extension;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOption() {
        return this.option;
    }

    public static EnumLogExport findByOptionName(String option) {
        return OPTION_MAP.get(option);
    }
}

