/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.export;

import com.vmware.vide.vlogbrowser.core.export.ILogEntryAccessor;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import java.util.List;

public class LogItemAdaptor
implements ILogEntryAccessor {
    private String[] columns;
    private final List<LogItem> logItems;
    private final LogFormat logFormat;

    public LogItemAdaptor(List<LogItem> logItems, LogFormat logFormat) {
        this.logItems = logItems;
        this.logFormat = logFormat;
        this.columns = logFormat.getColumnNames();
    }

    @Override
    public String[] getColumns() {
        return this.columns;
    }

    @Override
    public int getEntryCount() {
        return this.logItems.size();
    }

    @Override
    public String[] getEntryValues(int entry) throws Exception {
        LogItem logItem = this.logItems.get(entry);
        String[] values = new String[this.columns.length];
        int i = 0;
        while (i < this.columns.length) {
            values[i] = logItem.getLogField(i, this.logFormat).toString();
            ++i;
        }
        return values;
    }

    @Override
    public String getExtraLines(int entry) throws Exception {
        LogItem logItem = this.logItems.get(entry);
        return logItem.getLogExtra(this.logFormat);
    }
}

