/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.parser.LogDateFormat;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public class LogDate
extends Date {
    private static final long serialVersionUID = 1L;
    private LogDateFormat logDateFormat;
    private int numRollovers;
    public static DateFormat outputDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS Z");

    public LogDate(Long dateInMillis, LogDateFormat logDateFormat, int numRollovers) {
        super(dateInMillis);
        this.logDateFormat = logDateFormat;
        this.numRollovers = numRollovers;
    }

    @Override
    public long getTime() {
        long time = super.getTime();
        if (time == 0L) {
            return time;
        }
        return this.logDateFormat.correctYearlessDate(time, this.numRollovers);
    }

    @Override
    public void setTime(long time) {
        System.out.println("Warning: unimplemented setTime() called on a LogDate object (which extends Date)");
    }

    @Override
    public boolean after(Date when) {
        return this.compareTo(when) > 0;
    }

    @Override
    public boolean before(Date when) {
        return this.compareTo(when) < 0;
    }

    @Override
    public int compareTo(Date anotherDate) {
        long otherDate;
        long thisDate = this.getTime();
        if (thisDate < (otherDate = anotherDate.getTime())) {
            return -1;
        }
        if (otherDate == thisDate) {
            return 0;
        }
        return 1;
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof LogDate && this.compareTo((LogDate)obj) == 0;
    }

    @Override
    public String toString() {
        if (super.getTime() > 0L) {
            long timestamp = this.getTime();
            return outputDateFormat.format(timestamp += this.logDateFormat.getDateDelta());
        }
        return "";
    }

    public LogDateFormat getLogDateFormat() {
        return this.logDateFormat;
    }

    public void setLogDateFormat(LogDateFormat logDateFormat) {
        this.logDateFormat = logDateFormat;
    }

    public int getNumRollovers() {
        return this.numRollovers;
    }
}

