/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.consts.LogBrowserConsts;
import com.vmware.vide.vlogbrowser.core.model.FilterItem;
import java.util.ArrayList;
import java.util.List;

public class LogFilter {
    private String name;
    private List<List<FilterItem>> filterItemMatrix;
    private int numSurroundingLines;
    private boolean filterEnabled;
    private boolean isCaseSensitive;
    public static final int FIRST_ROW_IDX = 0;
    public static final int FIRST_COLUMN_IDX = 0;
    private int maxFilterItemIndex;

    public LogFilter(String name, int numSurroundingLines, int maxFilterColumns) {
        this.setName(name);
        this.filterItemMatrix = new ArrayList<List<FilterItem>>();
        this.setNumSurroundingLines(numSurroundingLines);
        this.filterEnabled = false;
        this.setMaxFilterColumns(maxFilterColumns);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName == null ? "" : newName;
    }

    public int getNumSurroundingLines() {
        return this.numSurroundingLines;
    }

    public void setNumSurroundingLines(int surroundingLines) {
        if (surroundingLines < 0 || surroundingLines > 9) {
            surroundingLines = 0;
        }
        this.numSurroundingLines = surroundingLines;
    }

    public int getMaxFilterColumns() {
        return this.maxFilterItemIndex + 1;
    }

    public void setMaxFilterColumns(int maxFilterColumns) {
        this.maxFilterItemIndex = maxFilterColumns - 1;
    }

    public void setFilterEnabled(boolean filterEnabled) {
        this.filterEnabled = filterEnabled;
    }

    public boolean isFilterEnabled() {
        return this.filterEnabled;
    }

    private void checkIndexes(int rowIndex, int filterItemIndex) throws Exception {
        if (rowIndex >= this.filterItemMatrix.size()) {
            int i = this.filterItemMatrix.size();
            while (i <= rowIndex) {
                this.filterItemMatrix.add(new ArrayList());
                ++i;
            }
        } else if (rowIndex < 0) {
            throw new Exception("Problem getting/setting filter item: row index " + rowIndex + " is less than 0");
        }
        List<FilterItem> myFilterRow = this.filterItemMatrix.get(rowIndex);
        if (filterItemIndex >= myFilterRow.size() && filterItemIndex <= this.maxFilterItemIndex) {
            int i = myFilterRow.size();
            while (i <= filterItemIndex) {
                myFilterRow.add(new FilterItem());
                ++i;
            }
        } else if (filterItemIndex < 0 || filterItemIndex > this.maxFilterItemIndex) {
            throw new Exception("Problem getting/setting filter item: filter item index " + filterItemIndex + " out of the range 0 - " + this.maxFilterItemIndex);
        }
    }

    public FilterItem getFilterItem(int rowIndex, int filterItemIndex) throws Exception {
        this.checkIndexes(rowIndex, filterItemIndex);
        return this.filterItemMatrix.get(rowIndex).get(filterItemIndex);
    }

    public void setFilterItem(int rowIndex, int filterItemIndex, FilterItem filterItem) throws Exception {
        this.checkIndexes(rowIndex, filterItemIndex);
        this.filterItemMatrix.get(rowIndex).set(filterItemIndex, filterItem);
    }

    public int getFilterRowCount() {
        return this.filterItemMatrix.size();
    }

    public int getFilterColumnCount(int row) {
        if (row < 0 || row >= this.filterItemMatrix.size()) {
            return 0;
        }
        List<FilterItem> filterRow = this.filterItemMatrix.get(row);
        return filterRow.size();
    }

    private boolean evaluateFilterRow(List<FilterItem> myFilterRow, String sourceStr) {
        boolean matched = false;
        int columnIdx = 0;
        int columnCount = myFilterRow.size();
        while (!matched && columnIdx < columnCount) {
            if (columnIdx != 0 && myFilterRow.get(columnIdx).getBoolConnector() == LogBrowserConsts.BooleanConnector.SKIP) {
                ++columnIdx;
                continue;
            }
            matched = myFilterRow.get(columnIdx++).evaluate(sourceStr);
            while (columnIdx < columnCount && myFilterRow.get(columnIdx).getBoolConnector() != LogBrowserConsts.BooleanConnector.OR) {
                if (myFilterRow.get(columnIdx).getBoolConnector() == LogBrowserConsts.BooleanConnector.SKIP) {
                    ++columnIdx;
                    continue;
                }
                matched = matched && myFilterRow.get(columnIdx).evaluate(sourceStr);
                ++columnIdx;
            }
        }
        return matched;
    }

    public boolean evaluateFilterMatrix(String sourceStr) {
        boolean matched = false;
        int rowIdx = 0;
        int rowCount = this.filterItemMatrix.size();
        int columnCount = rowCount > rowIdx ? this.filterItemMatrix.get(rowIdx).size() : -1;
        while (!matched && rowIdx < rowCount) {
            if (columnCount == 0 || rowIdx != 0 && this.filterItemMatrix.get(rowIdx).get(0).getBoolConnector() == LogBrowserConsts.BooleanConnector.SKIP) {
                columnCount = rowCount > ++rowIdx ? this.filterItemMatrix.get(rowIdx).size() : -1;
                continue;
            }
            matched = this.evaluateFilterRow(this.filterItemMatrix.get(rowIdx++), sourceStr);
            columnCount = rowCount > rowIdx ? this.filterItemMatrix.get(rowIdx).size() : -1;
            while (rowIdx < rowCount && (columnCount == 0 || this.filterItemMatrix.get(rowIdx).get(0).getBoolConnector() != LogBrowserConsts.BooleanConnector.OR)) {
                if (columnCount == 0 || this.filterItemMatrix.get(rowIdx).get(0).getBoolConnector() == LogBrowserConsts.BooleanConnector.SKIP) {
                    columnCount = rowCount > ++rowIdx ? this.filterItemMatrix.get(rowIdx).size() : -1;
                    continue;
                }
                matched = matched && this.evaluateFilterRow(this.filterItemMatrix.get(rowIdx), sourceStr);
                int n = columnCount = rowCount > ++rowIdx ? this.filterItemMatrix.get(rowIdx).size() : -1;
            }
        }
        return matched;
    }

    public boolean isJustAKeyword() {
        FilterItem firstFilterItem;
        if (!this.name.isEmpty()) {
            return false;
        }
        if (this.filterItemMatrix.size() > 0 && this.filterItemMatrix.get(0).size() > 0 && ((firstFilterItem = this.filterItemMatrix.get(0).get(0)).isNegateFlagSet() || firstFilterItem.isRegexFlagSet())) {
            return false;
        }
        for (List<FilterItem> filterItemRow : this.filterItemMatrix) {
            for (FilterItem filterItem : filterItemRow) {
                if (filterItem.getBoolConnector() == LogBrowserConsts.BooleanConnector.SKIP) continue;
                return false;
            }
        }
        return true;
    }

    public String getFirstKeyword() throws Exception {
        this.checkIndexes(0, 0);
        return this.filterItemMatrix.get(0).get(0).getKeyword();
    }

    public void setFirstKeyword(String keyword) throws Exception {
        this.checkIndexes(0, 0);
        this.filterItemMatrix.get(0).get(0).setKeyword(keyword);
    }

    public int getNumRows() {
        return this.filterItemMatrix.size();
    }

    public int getNumColumns(int rowNum) {
        if (rowNum < this.filterItemMatrix.size() && this.filterItemMatrix.get(rowNum) != null) {
            return this.filterItemMatrix.get(rowNum).size();
        }
        return 0;
    }

    public void printLogFilter() {
        System.out.println("***********************************");
        System.out.println("Log Filter name: " + this.name);
        System.out.println("Log Filter is enabled: " + this.filterEnabled);
        for (List<FilterItem> myFilterItemList : this.filterItemMatrix) {
            for (FilterItem filterItem : myFilterItemList) {
                System.out.print(String.valueOf(filterItem.getBoolConnector().toString()) + (filterItem.isNegateFlagSet() ? " NOT " : " ") + filterItem.getKeyword() + (filterItem.isRegexFlagSet() ? " (RegEx)  " : "  "));
            }
            System.out.println("");
        }
        System.out.println("Log Filter surrounding lines: " + this.numSurroundingLines);
        System.out.println("***********************************");
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
    }

    public boolean isCaseSensitive() {
        return this.isCaseSensitive;
    }
}

