/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import java.io.IOException;
import java.util.Date;

public class LogItem {
    private boolean alwaysMatched;
    private boolean properlyFormed;
    private int groupId;
    public static final int EXTRA_LIMIT = 25000;
    private final long fileOffset;
    private int readLength;
    private Date date;
    private long logIndexNum;
    private final int logFileNum;

    public LogItem(boolean properlyFormed, long fileOffset, int readLength, Date date, long logIndexNum, int logFileNum) {
        this.properlyFormed = properlyFormed;
        this.fileOffset = fileOffset;
        this.readLength = readLength;
        this.date = date;
        this.logIndexNum = logIndexNum;
        this.logFileNum = logFileNum;
        this.alwaysMatched = false;
        this.groupId = 0;
    }

    public Object getLogField(int columnIndex, LogFormat myLogFormat) throws IOException {
        if (columnIndex == this.getLogIndex(myLogFormat)) {
            return new Long(this.logIndexNum);
        }
        if (columnIndex == this.getDateIndex(myLogFormat)) {
            if (this.date != null) {
                return this.date;
            }
            return "";
        }
        byte[] byteBuffer = new byte[this.readLength];
        myLogFormat.getRandAccFile(this.logFileNum).readBytes(byteBuffer, this.fileOffset);
        String logLine = new String(byteBuffer);
        if (this.properlyFormed) {
            return myLogFormat.getLogCell(columnIndex, logLine);
        }
        if (columnIndex == this.getDefaultIndex(myLogFormat)) {
            return myLogFormat.getLogPreamble(logLine);
        }
        return "";
    }

    public Comparable<Object> getLogFieldComparable(int columnIndex, LogFormat myLogFormat) throws IOException {
        return (Comparable)this.getLogField(columnIndex, myLogFormat);
    }

    public Object[] getLogFieldsArr(LogFormat myLogFormat) throws IOException {
        Object[] logFields = new Object[myLogFormat.getColumnNames().length];
        int i = 0;
        while (i < logFields.length) {
            logFields[i] = this.getLogField(i, myLogFormat);
            ++i;
        }
        return logFields;
    }

    public String getLogExtra(LogFormat myLogFormat) throws IOException {
        byte[] byteBuffer = new byte[this.readLength];
        myLogFormat.getRandAccFile(this.logFileNum).readBytes(byteBuffer, this.fileOffset);
        return myLogFormat.getLogExtra(new String(byteBuffer, myLogFormat.getCharEncode()));
    }

    public byte[] getLogEntryBytes(LogFormat myLogFormat) throws IOException {
        byte[] byteBuffer = new byte[this.readLength];
        myLogFormat.getRandAccFile(this.logFileNum).readBytes(byteBuffer, this.fileOffset);
        return byteBuffer;
    }

    public int getDefaultIndex(LogFormat myLogFormat) {
        return myLogFormat.getDefaultColumnIndex();
    }

    public String getDefaultColumnString(LogFormat myLogFormat) throws IOException {
        return this.getLogField(this.getDefaultIndex(myLogFormat), myLogFormat).toString();
    }

    public String toVerboseString(LogFormat myLogFormat) throws IOException {
        String retStr = "";
        retStr = String.valueOf(retStr) + "******************\n";
        int i = 0;
        while (i < myLogFormat.getColumnNames().length) {
            retStr = String.valueOf(retStr) + i + ": '" + this.getLogField(i, myLogFormat).toString() + "'\n";
            ++i;
        }
        retStr = String.valueOf(retStr) + "Log Extra:\n" + this.getLogExtra(myLogFormat) + "\n";
        retStr = String.valueOf(retStr) + "******************\n";
        return retStr;
    }

    public String toBriefString(LogFormat myLogFormat) throws IOException {
        String retStr = "";
        int i = 0;
        while (i < myLogFormat.getColumnNames().length) {
            String s = this.getLogField(i, myLogFormat).toString();
            if (s.length() > 0 && s.charAt(0) == '\u0000') {
                s = s.replaceAll("\u0000", "");
            }
            retStr = String.valueOf(retStr) + " | " + s;
            ++i;
        }
        String logExtra = this.getLogExtra(myLogFormat);
        if (logExtra.length() > 0) {
            retStr = String.valueOf(retStr) + "\n" + logExtra + "\n";
        }
        return retStr;
    }

    public void setAlwaysMatched(boolean alwaysMatched) {
        this.alwaysMatched = alwaysMatched;
    }

    public boolean isAlwaysMatched() {
        return this.alwaysMatched;
    }

    public int getGroupId() {
        return this.groupId;
    }

    public void setGroupId(int id) {
        this.groupId = id;
    }

    public int getDateIndex(LogFormat myLogFormat) {
        return myLogFormat.getDateColumnIndex();
    }

    public int getLogIndex(LogFormat myLogFormat) {
        return myLogFormat.getLogIndexColumnIndex();
    }

    public void setLogIndexNum(long logIndexNum) {
        this.logIndexNum = logIndexNum;
    }

    public long getLogIndexNum() {
        return this.logIndexNum;
    }

    public Date getLogDate() {
        return this.date;
    }

    public void appendLogExtra(int additionalLength) {
        this.readLength += additionalLength;
    }

    public boolean isProperlyFormed() {
        return this.properlyFormed;
    }

    public void setProperlyFormed(boolean properlyFormed) {
        this.properlyFormed = properlyFormed;
    }

    public RAFile getSrcFile(LogFormat myLogFormat) {
        return myLogFormat.getRandAccFile(this.logFileNum);
    }

    public int getLogFileNum() {
        return this.logFileNum;
    }

    public long getFileOffset() {
        return this.fileOffset;
    }

    public int getReadLength() {
        return this.readLength;
    }

    public Date getDate() {
        return this.date;
    }

    public void setReadLength(int readLength) {
        this.readLength = readLength;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (int)(this.logIndexNum ^ this.logIndexNum >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LogItem other = (LogItem)obj;
        return this.logIndexNum == other.logIndexNum;
    }
}

