/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.model.LogItemBufferedFile;
import com.vmware.vide.vlogbrowser.core.model.util.FilteredList;
import com.vmware.vide.vlogbrowser.core.model.util.ISerializator;
import com.vmware.vide.vlogbrowser.core.model.util.PersistentList;
import java.io.File;
import java.io.RandomAccessFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogItemFilteredList
extends FilteredList<LogItem> {
    private String resName;
    private static final String FILES_DIR = ".vmwb/LogBrowser/raf/";
    private static final String FILTERED_SUFIX = ".filtered";
    private static final String UNFILTERED_SUFIX = ".unfiltered";
    private static final Logger logger = LoggerFactory.getLogger(LogItemFilteredList.class);

    public LogItemFilteredList(String resourceName, ISerializator<LogItem> serializator) {
        String resBaseName = resourceName.replaceFirst(".logx", "");
        this.allItems = PersistentList.create(this.getFile(String.valueOf(resBaseName) + UNFILTERED_SUFIX), serializator);
        this.filteredItems = PersistentList.create(this.getFile(String.valueOf(resBaseName) + FILTERED_SUFIX), serializator);
        this.resName = resourceName;
    }

    public String getResourceName() {
        return this.resName;
    }

    private RandomAccessFile getFile(String fileName) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceDir = workspace.getRoot().getLocation().toFile();
        File filesDir = new File(workspaceDir, FILES_DIR);
        if (!filesDir.exists()) {
            filesDir.mkdirs();
        }
        File file = new File(filesDir, fileName);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            return new LogItemBufferedFile(file, "rw");
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

