/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.model;

import com.vmware.vide.vlogbrowser.core.model.LogSystemType;
import java.util.List;

public class LogxFile {
    private boolean createThisFile;
    private String logFormatName;
    private String logCategory;
    private String logxFileName;
    private boolean openEditor;
    private String srcHost;
    private String archivePath;
    private String templateFilepath;
    private LogSystemType systemType;
    private boolean okFromSupportBundle;
    private boolean logFilesExist;
    private List<String> fileRegexes;

    public LogxFile(String logFormatName, String category, String templateFilepath, LogSystemType systemType) {
        this(logFormatName, category, templateFilepath, systemType, true);
    }

    public LogxFile(String logFormatName, String category, String templateFilepath, LogSystemType systemType, boolean okFromSupportBundle) {
        this.logFormatName = logFormatName;
        this.templateFilepath = templateFilepath;
        this.systemType = systemType;
        this.logCategory = category;
        this.okFromSupportBundle = okFromSupportBundle;
        this.logFilesExist = true;
    }

    public void setCreateThisFile(boolean createThisFile) {
        this.createThisFile = createThisFile;
    }

    public boolean isCreateThisFile() {
        return this.createThisFile;
    }

    public String getLogFormatName() {
        return this.logFormatName;
    }

    public String getCategory() {
        return this.logCategory;
    }

    public void setLogxFileName(String logxFileName) {
        this.logxFileName = logxFileName;
    }

    public String getLogxFileName() {
        return this.logxFileName;
    }

    public void setOpenEditor(boolean openEditor) {
        this.openEditor = openEditor;
    }

    public boolean isOpenEditor() {
        return this.openEditor;
    }

    public void setSrcHost(String srcHost) {
        this.srcHost = srcHost;
    }

    public String getSrcHost() {
        return this.srcHost;
    }

    public void setArchivePath(String archivePath) {
        this.archivePath = archivePath;
    }

    public String getArchivePath() {
        return this.archivePath;
    }

    public void setFileRegexes(List<String> fileRegexes) {
        this.fileRegexes = fileRegexes;
    }

    public List<String> getFileRegexes() {
        return this.fileRegexes;
    }

    public LogSystemType getSystemType() {
        return this.systemType;
    }

    public String toSummaryString() {
        String retStr = String.valueOf(this.srcHost) + " (" + this.logFormatName + ")";
        if (this.archivePath != null && this.archivePath.length() > 0) {
            retStr = String.valueOf(retStr);
        }
        return retStr;
    }

    public boolean equals(Object obj) {
        if (obj instanceof LogxFile) {
            LogxFile otherLxFile = (LogxFile)obj;
            return this.npeSafeEquals(this.srcHost, otherLxFile.srcHost) && this.npeSafeEquals(this.logFormatName, otherLxFile.logFormatName) && this.npeSafeEquals(this.getSystemType(), otherLxFile.getSystemType()) && this.npeSafeEquals(this.archivePath, otherLxFile.archivePath);
        }
        return false;
    }

    private boolean npeSafeEquals(Object thisObj, Object otherObj) {
        if (thisObj == null) {
            return otherObj == null;
        }
        return thisObj.equals(otherObj);
    }

    public String getTemplateFilePath() {
        return this.templateFilepath;
    }

    public void setOkFromSupportBundle(boolean okFromSupportBundle) {
        this.okFromSupportBundle = okFromSupportBundle;
    }

    public boolean isOkFromSupportBundle() {
        return this.okFromSupportBundle;
    }

    public void setLogFilesExist(boolean exist) {
        this.logFilesExist = exist;
    }

    public boolean logFilesExist() {
        return this.logFilesExist;
    }
}

