/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.model.LogDate;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogDateFormat;
import com.vmware.vide.vlogbrowser.core.parser.LogFormatException;
import com.vmware.vide.vlogbrowser.core.parser.RAFile;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogFormat {
    private final String name;
    private List<RAFile> randAccFiles;
    public static final int DEFAULT_LOWER_BOUND = 0;
    public static final int DEFAULT_UPPER_BOUND = Integer.MAX_VALUE;
    public static final int DEFAULT_REGEX_GROUP = 0;
    public static String newline = "\n";
    public static final String VALID_COL_TYPES = "LOGINDEX TEXT DATE";
    public static final ColumnType DEFAULT_COLUMN_TYPE = ColumnType.TEXT;
    private final ArrayList<Field> fields;
    private final ArrayList<Column> columns;
    private Column defaultColumn;
    private Column dateColumn;
    private Column logIndexColumn;
    private int defaultColumnIndex = -1;
    private int dateColumnIndex = -1;
    private int logIndexColumnIndex = -1;
    private int sizeLimitMB = -1;
    private final List<String> knownFilenames;

    public String getName() {
        return this.name;
    }

    private Field getField(String name) {
        for (Field field : this.fields) {
            if (!field.name.equals(name)) continue;
            return field;
        }
        return null;
    }

    private int properNumberFromString(String numStr, String numStrName, int lowerLimit, int upperLimit, int defaultNum) throws Exception {
        int returnNum = 0;
        if (numStr == null || numStr.trim().equals("")) {
            returnNum = defaultNum;
        } else {
            try {
                returnNum = Integer.parseInt(numStr);
                if (returnNum < lowerLimit || returnNum > upperLimit) {
                    throw new Exception();
                }
            }
            catch (Exception exception) {
                throw new Exception(String.valueOf(numStrName) + " '" + numStr + "' is not valid. It must be left blank or be an integer between " + lowerLimit + " and " + upperLimit + " inclusive.");
            }
        }
        return returnNum;
    }

    public int getDefaultColumnIndex() {
        return this.defaultColumnIndex;
    }

    public int getDateColumnIndex() {
        return this.dateColumnIndex;
    }

    public int getLogIndexColumnIndex() {
        return this.logIndexColumnIndex;
    }

    private Column getColumn(String name) {
        for (Column column : this.columns) {
            if (!column.name.equals(name)) continue;
            return column;
        }
        return null;
    }

    public String[] getColumnNames() {
        String[] retStringArr = new String[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            retStringArr[i] = this.columns.get((int)i).name;
            ++i;
        }
        return retStringArr;
    }

    public int[] getColumnWeights() {
        int[] retIntArr = new int[this.columns.size()];
        int i = 0;
        while (i < this.columns.size()) {
            retIntArr[i] = this.columns.get((int)i).widthWeight;
            ++i;
        }
        return retIntArr;
    }

    public int getSizeLimitMB() {
        return this.sizeLimitMB;
    }

    public void setSizeLimitMB(int value) {
        this.sizeLimitMB = value;
    }

    public LogFormat(String name) throws Exception {
        if (name == null || name.trim().equals("")) {
            throw new Exception("Log format must be named");
        }
        this.name = name.trim();
        this.fields = new ArrayList(10);
        this.columns = new ArrayList(10);
        this.knownFilenames = new ArrayList<String>(10);
    }

    public void addKnownFilename(String regexFilename) {
        this.knownFilenames.add(regexFilename);
    }

    public List<String> getKnownFilenames() {
        return this.knownFilenames;
    }

    public void addField(String name, String lowerBound, String upperBound, String regexMatch, String regexCaptureGroup) throws LogFormatException {
        try {
            if (this.getField(name) != null) {
                throw new Exception("Field name is not unique.");
            }
            this.fields.add(new Field(name, this.fields.size(), lowerBound, upperBound, regexMatch, regexCaptureGroup));
        }
        catch (Exception e) {
            throw new LogFormatException("Bad Field '" + name + "' in LogFormat '" + this.name + "': " + e.getMessage(), e);
        }
    }

    public void addColumn(String name, String isDefault, String widthWeight, String columnType, String dateFormat, String fieldGlue) throws LogFormatException {
        try {
            if (this.getColumn(name) != null) {
                throw new Exception("Column name is not unique.");
            }
            Column column = new Column(name, this.columns.size(), isDefault, widthWeight, columnType, dateFormat, fieldGlue);
            this.columns.add(column);
            if (column.isDefault) {
                if (this.defaultColumn != null) {
                    throw new Exception("Only one column can be the default. Duplicate found at column " + name);
                }
                this.defaultColumn = column;
                this.defaultColumnIndex = this.defaultColumn.index;
            }
            if (column.getDateFormat() != null) {
                if (this.dateColumn != null) {
                    throw new Exception("Only one column can be the DATE column. Additional DATE found at column " + name);
                }
                this.dateColumn = column;
                this.dateColumnIndex = this.dateColumn.index;
            }
            if (column.columnType == ColumnType.LOGINDEX) {
                if (this.logIndexColumn != null) {
                    throw new Exception("Only one column can be the LOGINDEX column. Additional LOGINDEX found at column " + name);
                }
                this.logIndexColumn = column;
                this.logIndexColumnIndex = this.logIndexColumn.index;
            }
            if (column.isDefault && column.getDateFormat() != null) {
                throw new Exception("Invalid type DATE found at default column " + name);
            }
            if (column.isDefault && column.columnType == ColumnType.LOGINDEX) {
                throw new Exception("The LOGINDEX column " + name + " cannot be the" + " default column.");
            }
        }
        catch (Exception e) {
            throw new LogFormatException("Bad Column '" + name + "' in LogFormat '" + this.name + "': " + e.getMessage(), e);
        }
    }

    public void addFieldToColumn(String fieldName, String columnName) throws LogFormatException {
        if (columnName == null || this.getColumn(columnName.trim()) == null) {
            throw new LogFormatException("Column '" + columnName + "' is invalid.");
        }
        if (fieldName == null || this.getField(fieldName.trim()) == null) {
            throw new LogFormatException("Cannot find field '" + fieldName + "' referenced within column " + columnName + " within LogFormat " + this.name);
        }
        Column columnObj = this.getColumn(columnName.trim());
        Field fieldObj = this.getField(fieldName.trim());
        if (columnObj.columnType == ColumnType.LOGINDEX) {
            throw new LogFormatException("The LOGINDEX column " + columnName + " cannot have any fields assigned to it.");
        }
        columnObj.fieldsAssigned.add(fieldObj);
    }

    private Column getColumnByAssignedField(String fieldName) {
        for (Column column : this.columns) {
            for (Field field : column.fieldsAssigned) {
                if (!fieldName.equals(field.name)) continue;
                return column;
            }
        }
        return null;
    }

    public LogItem initialParse(String logLine, LogItem lastLogItem, long fileOffset, int readLength, int logFileNum, long logIndexNum, LogDateFormat dateFormat) {
        Column myColumn = this.getColumnByAssignedField("Date");
        Object dateObj = this.getLogCell(myColumn.index, logLine, dateFormat);
        if (dateObj != null) {
            return new LogItem(true, fileOffset, readLength, (Date)dateObj, logIndexNum, logFileNum);
        }
        if (lastLogItem != null) {
            lastLogItem.appendLogExtra(readLength);
            return null;
        }
        return new LogItem(false, fileOffset, readLength, new LogDate(0L, dateFormat, 0), logIndexNum, logFileNum);
    }

    public Object getLogCell(int columnIndex, String logLine) {
        LogDateFormat dateFormat = this.getDateFormat();
        return this.getLogCell(columnIndex, logLine, dateFormat);
    }

    public Object getLogCell(int columnIndex, String logLine, LogDateFormat dateFormat) {
        String retStr = "";
        Column myColumn = this.columns.get(columnIndex);
        ArrayList<Field> columnFields = myColumn.fieldsAssigned;
        for (Field field : columnFields) {
            String fieldStr = "";
            int lowerBound = field.lowerBound;
            int upperBound = field.upperBound > logLine.length() ? logLine.length() : field.upperBound;
            boolean found = false;
            if (lowerBound < logLine.length() && lowerBound < upperBound) {
                fieldStr = logLine.substring(lowerBound, upperBound);
                if (field.regexMatch != null && field.regexMatch.toString().length() > 0) {
                    Matcher matcher = field.regexMatch.matcher(fieldStr);
                    if (matcher.find()) {
                        try {
                            fieldStr = fieldStr.substring(matcher.start(field.regexCaptureGroup), matcher.end(field.regexCaptureGroup));
                            found = true;
                        }
                        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                            found = false;
                        }
                    }
                } else {
                    found = true;
                }
            }
            if (myColumn.columnType == ColumnType.DATE) {
                if (found) {
                    try {
                        LogDate result = (LogDate)dateFormat.parse(fieldStr);
                        result.setLogDateFormat(myColumn.getDateFormat());
                        return result;
                    }
                    catch (ParseException parseException) {}
                }
                return null;
            }
            if (!found) continue;
            if (retStr.length() > 0) {
                retStr = String.valueOf(retStr) + myColumn.fieldGlue;
            }
            retStr = String.valueOf(retStr) + fieldStr;
        }
        return retStr;
    }

    public String getLogExtra(String logLine) {
        int nlIdx = logLine.indexOf(newline);
        if (nlIdx < 0) {
            return "";
        }
        return this.getLogSubstring(logLine, nlIdx + newline.length(), logLine.length());
    }

    public String getLogPreamble(String logLine) {
        return this.getLogSubstring(logLine, 0, logLine.indexOf(newline));
    }

    private String getLogSubstring(String logLine, int begin, int end) {
        try {
            return logLine.substring(begin, end);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return "";
        }
    }

    public void loadNewRAFileList(List<RAFile> raFiles) throws IOException {
        this.closeAllRandAccFiles();
        if (this.randAccFiles != null) {
            this.randAccFiles.clear();
        }
        this.randAccFiles = raFiles;
    }

    public List<RAFile> getRandAccFileList() {
        return this.randAccFiles;
    }

    public RAFile getRandAccFile(int logFileNum) {
        return this.randAccFiles.get(logFileNum);
    }

    public void openRandAccFile(int logFileNum) throws IOException {
        this.randAccFiles.get(logFileNum).open();
    }

    public void openAllRandAccFiles() throws IOException {
        int i = 0;
        while (i < this.randAccFiles.size()) {
            this.openRandAccFile(i);
            ++i;
        }
    }

    public void closeRandAccFile(int logFileNum) throws IOException {
        if (this.randAccFiles != null && this.randAccFiles.size() > logFileNum && this.randAccFiles.get(logFileNum) != null) {
            this.randAccFiles.get(logFileNum).close();
        }
    }

    public void closeAllRandAccFiles() throws IOException {
        if (this.randAccFiles != null) {
            int i = 0;
            while (i < this.randAccFiles.size()) {
                this.closeRandAccFile(i);
                ++i;
            }
        }
    }

    public boolean matchesCompletely(String logLine) {
        for (Column column : this.columns) {
            if (column.columnType == ColumnType.LOGINDEX) continue;
            Object obj = this.getLogCell(column.index, logLine);
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof String) || ((String)obj).trim().length() != 0) continue;
            return false;
        }
        return true;
    }

    public void updateDate(Date fileTimestamp) throws Exception {
        this.dateColumn.updateDateFormatObj(fileTimestamp);
    }

    public void setDateDelta(long dateDelta) throws Exception {
        this.dateColumn.setDateDelta(dateDelta);
    }

    public Long getDateDelta() {
        return this.dateColumn.getDateDelta();
    }

    public LogDateFormat getDateFormat() {
        Column column = this.getColumnByAssignedField("Date");
        LogDateFormat result = column == null ? null : column.getDateFormat();
        return result;
    }

    public String getCharEncode() {
        return "UTF-8";
    }

    private class Column {
        String name;
        int index;
        boolean isDefault;
        int widthWeight;
        ArrayList<Field> fieldsAssigned;
        ColumnType columnType;
        private LogDateFormat columnDateFormat;
        String fieldGlue;

        Column(String name, int index, String isDefault, String widthWeight, String columnType, String dateFormat, String fieldGlue) throws Exception {
            if (name == null || name.trim().equals("")) {
                throw new Exception("Column name '" + name + "' is not valid. " + "It must have a valid non-empty name.");
            }
            this.name = name.trim();
            this.index = index;
            if (isDefault == null || isDefault.equals("") || isDefault.trim().equalsIgnoreCase("false")) {
                this.isDefault = false;
            } else {
                this.isDefault = Boolean.parseBoolean(isDefault);
                if (!this.isDefault) {
                    throw new Exception("IsDefault value '" + isDefault + "' is not valid. It must be left blank (defaults " + "to false), or be set to 'true' or 'false'");
                }
            }
            this.widthWeight = LogFormat.this.properNumberFromString(widthWeight, "WidthWeight", 1, Integer.MAX_VALUE, 1);
            if (columnType == null || columnType.trim().equals("")) {
                this.columnType = DEFAULT_COLUMN_TYPE;
            } else {
                try {
                    this.columnType = ColumnType.valueOf(columnType.trim());
                }
                catch (Exception exception) {
                    throw new Exception("ColumnType '" + columnType + "' is not valid. It must be blank or have one " + "of these values: " + LogFormat.VALID_COL_TYPES);
                }
            }
            this.columnDateFormat = dateFormat == null || dateFormat.trim().equals("") ? null : new LogDateFormat(dateFormat, new Date());
            if (this.columnType == ColumnType.DATE && this.columnDateFormat == null || this.columnType != ColumnType.DATE && this.columnDateFormat != null) {
                throw new Exception("Column Type " + columnType + " does not match" + " DateFormat in column " + name + ".");
            }
            if (this.columnType == ColumnType.LOGINDEX && this.isDefault) {
                throw new Exception("The Column of type LOGINDEX cannot be the default column");
            }
            this.fieldsAssigned = new ArrayList(10);
            this.fieldGlue = fieldGlue == null ? "" : fieldGlue;
            if (this.columnType == ColumnType.LOGINDEX && !this.fieldGlue.equals("")) {
                throw new Exception("In the Column of type LOGINDEX, FieldGlue must be left unset.");
            }
        }

        public void updateDateFormatObj(Date newLogFileDate) throws Exception {
            try {
                this.columnDateFormat.initLogDate(newLogFileDate);
            }
            catch (IllegalArgumentException e) {
                throw new Exception("DateFormat '" + this.columnDateFormat + "' in column + " + this.name + " is invalid. " + e.getMessage());
            }
        }

        public void setDateDelta(long dateDelta) throws Exception {
            this.columnDateFormat.setDateDelta(dateDelta);
        }

        public Long getDateDelta() {
            if (this.columnDateFormat == null) {
                return null;
            }
            return this.columnDateFormat.getDateDelta();
        }

        public LogDateFormat getDateFormat() {
            return this.columnDateFormat;
        }
    }

    public static enum ColumnType {
        LOGINDEX,
        TEXT,
        DATE;

    }

    private class Field {
        String name;
        int lowerBound;
        int upperBound;
        Pattern regexMatch;
        int regexCaptureGroup;

        Field(String name, int index, String lowerBound, String upperBound, String regexMatch, String regexCaptureGroup) throws Exception {
            if (name == null || name.trim().equals("")) {
                throw new Exception("Field name '" + name + "' is not valid");
            }
            this.name = name.trim();
            this.lowerBound = LogFormat.this.properNumberFromString(lowerBound, "LowerBound", 0, Integer.MAX_VALUE, 0);
            this.upperBound = LogFormat.this.properNumberFromString(upperBound, "UpperBound", this.lowerBound + 1, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.regexMatch = Pattern.compile(regexMatch.trim());
            this.regexCaptureGroup = LogFormat.this.properNumberFromString(regexCaptureGroup, "RegexCaptureGroup", 0, Integer.MAX_VALUE, 0);
        }
    }
}

