/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import org.xml.sax.SAXParseException;

public class LogFormatException
extends Exception {
    public static final int INVALID_LINE = -1;
    public static final int INVALID_COLUMN = -1;
    private static final long serialVersionUID = -963522419744343335L;
    private int line;
    private int column;

    public LogFormatException(String message) {
        super(message);
        this.line = -1;
        this.column = -1;
    }

    public LogFormatException(String message, Throwable cause) {
        super(message, cause);
        this.line = -1;
        this.column = -1;
        this.updateLineColumnInfo(cause);
    }

    public LogFormatException(String message, int line, int column, Throwable cause) {
        super(message, cause);
        this.line = line;
        this.column = column;
        this.updateLineColumnInfo(cause);
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    private void updateLineColumnInfo(Throwable cause) {
        if (cause != null && cause instanceof SAXParseException) {
            SAXParseException se = (SAXParseException)cause;
            this.line = se.getLineNumber();
            this.column = se.getColumnNumber();
        }
    }
}

