/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.parser;

import com.vmware.vide.vlogbrowser.core.model.LogFilter;
import com.vmware.vide.vlogbrowser.core.model.LogItem;
import com.vmware.vide.vlogbrowser.core.parser.LogFormat;
import com.vmware.vide.vlogbrowser.core.parser.MultiMatcher;
import java.io.IOException;

public class LogItemMatcher
implements MultiMatcher {
    private String filterText;
    private LogFormat logFormat;
    private boolean isCaseSensitive;
    private boolean isJustAKeyword;

    public LogItemMatcher(String filterText, LogFormat logFormat) {
        this.filterText = filterText;
        this.logFormat = logFormat;
    }

    public LogItemMatcher(LogFilter logFilter, LogFormat logFormat) throws Exception {
        this(logFilter.getFirstKeyword(), logFormat);
        this.isCaseSensitive = logFilter.isCaseSensitive();
        this.isJustAKeyword = logFilter.isJustAKeyword();
    }

    @Override
    public boolean matches(LogItem logItem) {
        if (logItem.isAlwaysMatched()) {
            return true;
        }
        return this.matchesSomeField(logItem);
    }

    @Override
    public boolean matchesSomeField(LogItem logItem) {
        try {
            String logEntryText = new String(logItem.getLogEntryBytes(this.logFormat));
            if (this.isCaseSensitive && this.isJustAKeyword) {
                return logEntryText.indexOf(this.filterText) > -1;
            }
            return logEntryText.toLowerCase().indexOf(this.filterText.toLowerCase()) > -1;
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            return false;
        }
    }
}

