/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.script.api;

import com.vmware.vide.vlogbrowser.core.script.api.ILogBrowserScriptRecorder;
import java.io.File;

public class LogBrowserScriptRecorderManager {
    private static LogBrowserScriptRecorderManager instance = new LogBrowserScriptRecorderManager();
    private LogBrowserScriptRecorderDecorator recorder;
    private Object mutex = this;

    private LogBrowserScriptRecorderManager() {
        this.recorder = new LogBrowserScriptRecorderDecorator(this.mutex);
    }

    public static LogBrowserScriptRecorderManager getInstance() {
        return instance;
    }

    public ILogBrowserScriptRecorder getRecorder() {
        return this.recorder;
    }

    public void setImplementationRecorder(ILogBrowserScriptRecorder implementation) {
        this.recorder.setRecorder(implementation);
    }

    private class LogBrowserScriptRecorderDecorator
    implements ILogBrowserScriptRecorder {
        private Object mutex;
        private ILogBrowserScriptRecorder recorder;
        private final ILogBrowserScriptRecorder nullRecorder;

        public LogBrowserScriptRecorderDecorator(Object mutex) {
            this.nullRecorder = new NullLogBrowserScriptRecorder();
            this.mutex = mutex;
            this.recorder = this.nullRecorder;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setRecorder(ILogBrowserScriptRecorder implementation) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder = implementation == null ? this.nullRecorder : implementation;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getProjectManifest(String project) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getProjectManifest(project);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getLogTypes(String host, String hostType, String hostVer) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getLogTypes(host, hostType, hostVer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getManifest(String prjName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getManifest(prjName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getRefreshProgress(String prjName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getRefreshProgress(prjName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void refreshLogs(String prjName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.refreshLogs(prjName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void defineLog(String typeName, File file) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.defineLog(typeName, file);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void selectLog(String prjName, String hostName, String logxType, String path) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.selectLog(prjName, hostName, logxType, path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getCount(String prjName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getCount(prjName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getColumnList(String prjName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getColumnList(prjName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getEntryList(String prjName, String resName, String filterString, String firstIndex, String count) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getEntryList(prjName, resName, filterString, firstIndex, count);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void findPattern(String prjName, String resName, String pattern, String firstIndex, String time) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.findPattern(prjName, resName, pattern, firstIndex, time);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void adjustTime(String prjName, String resName, String timeString) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.adjustTime(prjName, resName, timeString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getFilters(String prjName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getFilters(prjName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void getFilters(String prjName, String resName, String filterName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.getFilters(prjName, resName, filterName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyFilter(String prjName, String resName, String filterString, String aroundString) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.applyFilter(prjName, resName, filterString, aroundString);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void applyFilterByName(String prjName, String resName, String filterName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.applyFilterByName(prjName, resName, filterName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void saveFilter(String prjName, String resName, String filterName, String filterXml) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.saveFilter(prjName, resName, filterName, filterXml);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteFilter(String prjName, String resName, String filterName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.deleteFilter(prjName, resName, filterName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void fetchLogFileOrBundle(String prjName, String hostName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.fetchLogFileOrBundle(prjName, hostName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void deleteLogFile(String prjName, String hostName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.deleteLogFile(prjName, hostName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unfilter(String prjName, String resName) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.unfilter(prjName, resName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void downloadAndStageLogFiles(String prjName, String[] logxTypes, String hostName, String hostType, String userName, String password, String path) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.downloadAndStageLogFiles(prjName, logxTypes, hostName, hostType, userName, password, path);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void export(String prjName, String resName, String format, String localFilePath, boolean filteredEntriesOnly) {
            Object object = this.mutex;
            synchronized (object) {
                this.recorder.export(prjName, resName, format, localFilePath, filteredEntriesOnly);
            }
        }
    }

    private class NullLogBrowserScriptRecorder
    implements ILogBrowserScriptRecorder {
        private NullLogBrowserScriptRecorder() {
        }

        @Override
        public void getProjectManifest(String project) {
        }

        @Override
        public void getLogTypes(String host, String hostType, String hostVer) {
        }

        @Override
        public void getManifest(String prjName, String resName) {
        }

        @Override
        public void getRefreshProgress(String prjName, String resName) {
        }

        @Override
        public void refreshLogs(String prjName, String resName) {
        }

        @Override
        public void defineLog(String typeName, File file) {
        }

        @Override
        public void selectLog(String prjName, String hostName, String logxType, String path) {
        }

        @Override
        public void getCount(String prjName, String resName) {
        }

        @Override
        public void getColumnList(String prjName, String resName) {
        }

        @Override
        public void getEntryList(String prjName, String resName, String filterString, String firstIndex, String count) {
        }

        @Override
        public void findPattern(String prjName, String resName, String pattern, String firstIndex, String time) {
        }

        @Override
        public void adjustTime(String prjName, String resName, String timeString) {
        }

        @Override
        public void getFilters(String prjName, String resName) {
        }

        @Override
        public void getFilters(String prjName, String resName, String filterName) {
        }

        @Override
        public void applyFilter(String prjName, String resName, String filterString, String aroundString) {
        }

        @Override
        public void applyFilterByName(String prjName, String resName, String filterName) {
        }

        @Override
        public void saveFilter(String prjName, String resName, String filterName, String filterXml) {
        }

        @Override
        public void deleteFilter(String prjName, String resName, String filterName) {
        }

        @Override
        public void fetchLogFileOrBundle(String prjName, String hostName, String resName) {
        }

        @Override
        public void deleteLogFile(String prjName, String hostName, String resName) {
        }

        @Override
        public void unfilter(String prjName, String resName) {
        }

        @Override
        public void export(String prjName, String resName, String format, String localFilePath, boolean filteredEntriesOnly) {
        }

        @Override
        public void downloadAndStageLogFiles(String prjName, String[] logxTypes, String hostName, String hostType, String userName, String password, String path) {
        }
    }
}

