/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.vlogbrowser.core.script.recorder;

import com.vmware.vide.utils.script.recorder.IScriptRecording;
import com.vmware.vide.vlogbrowser.core.script.api.ILogBrowserScriptRecorder;
import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LogBrowserShellScriptRecorder
implements ILogBrowserScriptRecorder {
    private static final Logger logger = LoggerFactory.getLogger(LogBrowserShellScriptRecorder.class);
    private static final String EXE_NAME = "vmwb-lbcli";
    private static final int AVE_CMD_LENGTH = 256;
    private static final String EOL = "\n";
    private IScriptRecording recording;

    public LogBrowserShellScriptRecorder(IScriptRecording recording) {
        this.recording = recording;
    }

    @Override
    public void defineLog(String typeName, File file) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("define ");
        buffer.append(this.getFilePathForScript(file));
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void selectLog(String prjName, String hostName, String logxType, String path) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("select ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (hostName != null) {
            buffer.append("--host=\"");
            buffer.append(hostName);
            buffer.append("\" ");
        }
        if (logxType != null) {
            buffer.append("--type=\"");
            buffer.append(logxType);
            buffer.append("\" ");
        }
        if (path != null) {
            buffer.append("--path=\"");
            buffer.append(path);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void getCount(String prjName, String resName) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("count ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void getEntryList(String prjName, String resName, String filterString, String firstIndex, String count) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("print ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (filterString != null) {
            buffer.append("--filter");
        }
        if (firstIndex != null) {
            buffer.append("--first=\"");
            buffer.append(firstIndex);
            buffer.append("\" ");
        }
        if (count != null) {
            buffer.append("--count=\"");
            buffer.append(count);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void findPattern(String prjName, String resName, String pattern, String firstIndex, String time) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("find ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (pattern != null) {
            buffer.append("--pattern=\"");
            buffer.append(pattern);
            buffer.append("\" ");
        }
        if (firstIndex != null) {
            buffer.append("--first=\"");
            buffer.append(firstIndex);
            buffer.append("\" ");
        }
        if (time != null) {
            buffer.append("--time=\"");
            buffer.append(time);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void getFilters(String prjName, String resName) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("getfilter ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void getFilters(String prjName, String resName, String filterName) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("getfilter ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (filterName != null) {
            buffer.append("--name=\"");
            buffer.append(filterName);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void applyFilter(String prjName, String resName, String filterString, String aroundString) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(this.recording.getScriptCommentPrefix());
        buffer.append("Applying filter by pattern");
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("filter ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (aroundString != null) {
            buffer.append("--around=\"");
            buffer.append(aroundString);
            buffer.append("\" ");
        }
        if (filterString != null) {
            buffer.append("\"");
            buffer.append(filterString);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void applyFilterByName(String prjName, String resName, String filterName) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(this.recording.getScriptCommentPrefix());
        if (filterName == null || filterName.isEmpty()) {
            buffer.append("Removing currently applied filter");
        } else {
            buffer.append("Applying filter by name");
        }
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("filter ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (filterName != null) {
            buffer.append("--name=\"");
            buffer.append(filterName);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    private static String mungeValidFileName(String filterName) {
        String fileName = filterName.replaceAll("[\\s]", "_");
        fileName = fileName.replaceAll("[^\\p{Alnum}_]", "-");
        return fileName;
    }

    @Override
    public void saveFilter(String prjName, String resName, String filterName, String filterXml) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(this.recording.getScriptCommentPrefix());
        buffer.append("Saving filter '").append(filterName).append("'").append(EOL);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("save ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (filterXml != null) {
            try {
                File recordingFile = this.recording.getFile();
                if (recordingFile != null) {
                    File parentDir = recordingFile.getParentFile();
                    String filterFileName = "filter_" + LogBrowserShellScriptRecorder.mungeValidFileName(filterName) + ".xml";
                    File xmlFile = new File(parentDir, filterFileName);
                    FileUtils.writeStringToFile((File)xmlFile, (String)filterXml);
                    buffer.append(filterFileName);
                    buffer.append(" ");
                }
            }
            catch (Exception e) {
                logger.error("Exception while dumping filter xml to a file", (Throwable)e);
            }
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void deleteFilter(String prjName, String resName, String filterName) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("filter ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        buffer.append("--remove");
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void deleteLogFile(String prjName, String hostName, String resName) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("delete ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (hostName != null) {
            buffer.append("--host=\"");
            buffer.append(hostName);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void unfilter(String prjName, String resName) {
        this.applyFilterByName(prjName, resName, "");
    }

    @Override
    public void downloadAndStageLogFiles(String prjName, String[] logxTypes, String hostName, String hostType, String userName, String password, String path) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(this.recording.getScriptCommentPrefix());
        buffer.append("Connect to remote host and download the specified log files.").append(EOL);
        if (password == null) {
            buffer.append(this.recording.getScriptCommentPrefix());
            buffer.append("NOTE: this call is using a cached password.  You might need to add").append(EOL);
            buffer.append(this.recording.getScriptCommentPrefix());
            buffer.append("the --user and --password options in order to call this reliably headlessly.").append(EOL);
        }
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("download ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (logxTypes != null) {
            String[] stringArray = logxTypes;
            int n = logxTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String logxType = stringArray[n2];
                buffer.append("--type=\"");
                buffer.append(logxType);
                buffer.append("\" ");
                ++n2;
            }
        }
        if (hostName != null) {
            buffer.append("--host=\"");
            buffer.append(hostName);
            buffer.append("\" ");
        }
        if (hostType != null) {
            buffer.append("--htype=\"");
            buffer.append(hostType);
            buffer.append("\" ");
        }
        if (userName != null) {
            buffer.append("--user=\"");
            buffer.append(userName);
            buffer.append("\" ");
        }
        if (password != null) {
            buffer.append("--password=\"");
            buffer.append(password);
            buffer.append("\" ");
        }
        if (path != null) {
            buffer.append("--path=\"");
            buffer.append(path);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void export(String prjName, String resName, String format, String localFilePath, boolean filteredEntriesOnly) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(this.recording.getScriptCommentPrefix());
        buffer.append("export uses print command to direct output to a file");
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("print ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        buffer.append("--count=all ");
        if (!filteredEntriesOnly) {
            buffer.append("--nofilter ");
        }
        if (format != null) {
            buffer.append("--format=\"");
            buffer.append(format);
            buffer.append("\" ");
        }
        if (localFilePath != null) {
            buffer.append("--outfile=\"");
            buffer.append(localFilePath);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void adjustTime(String prjName, String resName, String timeString) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(EXE_NAME);
        buffer.append(" ");
        buffer.append("adjust ");
        if (prjName != null) {
            buffer.append("--project=\"");
            buffer.append(prjName);
            buffer.append("\" ");
        }
        if (resName != null) {
            buffer.append("--log=\"");
            buffer.append(resName);
            buffer.append("\" ");
        }
        if (timeString != null) {
            buffer.append("--time=\"");
            buffer.append(timeString);
            buffer.append("\" ");
        }
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }

    @Override
    public void getProjectManifest(String project) {
        this.appendUnhandledCommand("getProjectManifest", project);
    }

    @Override
    public void getLogTypes(String host, String hostType, String hostVer) {
        this.appendUnhandledCommand("getLogTypes", host, hostType, hostVer);
    }

    @Override
    public void getManifest(String prjName, String resName) {
        this.appendUnhandledCommand("getManifest", prjName, resName);
    }

    @Override
    public void getRefreshProgress(String prjName, String resName) {
        this.appendUnhandledCommand("getRefreshProgress", prjName, resName);
    }

    @Override
    public void refreshLogs(String prjName, String resName) {
        this.appendUnhandledCommand("refreshLogs", prjName, resName);
    }

    @Override
    public void getColumnList(String prjName, String resName) {
        this.appendUnhandledCommand("getColumnList", prjName, resName);
    }

    @Override
    public void fetchLogFileOrBundle(String prjName, String hostName, String resName) {
        this.appendUnhandledCommand("fetchLogFileOrBundle", prjName, resName);
    }

    private String getFilePathForScript(File f) {
        return f.getAbsolutePath();
    }

    private void appendUnhandledCommand(String command, String ... commandArgs) {
        StringBuilder buffer = new StringBuilder(256);
        buffer.append(EOL);
        buffer.append(this.recording.getScriptCommentPrefix());
        buffer.append("UNHANDLED COMMAND: ");
        buffer.append(command);
        buffer.append("(");
        if (commandArgs != null) {
            String argPrefix = "";
            int i = 0;
            while (i < commandArgs.length) {
                String arg = commandArgs[i];
                if (arg != null) {
                    buffer.append(argPrefix);
                    buffer.append(arg);
                    argPrefix = ",";
                }
                ++i;
            }
        }
        buffer.append(")");
        buffer.append(EOL);
        this.recording.append((CharSequence)buffer);
    }
}

