/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.api.impl;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.vmware.vide.rse.VIDERSEPlugin;
import com.vmware.vide.rse.api.impl.Target;
import com.vmware.vide.rse.api.impl.TargetFactory;
import com.vmware.vide.rse.api.impl.TargetManager;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetProcess;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class RemoteProcess
implements ITargetProcess {
    private Target target = null;
    private Session session = null;
    private Channel channel = null;

    public RemoteProcess(Target target, String command) throws JSchException {
        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)target.getHost());
        IConnectorService connector = fss.getConnectorService();
        if (connector instanceof SshConnectorService) {
            this.session = ((SshConnectorService)connector).getSession();
            this.channel = this.session.openChannel("exec");
            ((ChannelExec)this.channel).setCommand(command);
        }
        this.target = target;
    }

    public RemoteProcess(IHost host, String command) throws JSchException {
        this(TargetFactory.createTarget((TargetManager)VIDERSEPlugin.getTheTargetManager(), host), command);
    }

    public RemoteProcess(Session session, String command) throws JSchException {
        this.session = session;
        this.channel = session.openChannel("exec");
        ((ChannelExec)this.channel).setCommand(command);
    }

    public ITarget getTarget() {
        return this.target;
    }

    public void run() throws Exception {
        this.channel.connect();
    }

    public InputStream getInputStream() throws IOException {
        if (this.channel != null) {
            return this.channel.getInputStream();
        }
        return null;
    }

    public void setInputStream(InputStream in) {
        if (this.channel != null) {
            this.channel.setInputStream(in);
        }
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.channel != null) {
            return this.channel.getOutputStream();
        }
        return null;
    }

    public void setOutputStream(OutputStream out) {
        if (this.channel != null) {
            this.channel.setOutputStream(out);
        }
    }

    public InputStream getErrorStream() throws IOException {
        if (this.channel != null) {
            return ((ChannelExec)this.channel).getErrStream();
        }
        return null;
    }

    public void setErrorStream(OutputStream out) {
        if (this.channel != null) {
            ((ChannelExec)this.channel).setErrStream(out);
        }
    }

    public int exitValue() throws Exception {
        if (this.channel == null) {
            throw new Exception("No command channel is connected.");
        }
        return this.channel.getExitStatus();
    }

    public boolean isActive() {
        return this.channel != null && this.channel.isConnected();
    }

    public void destroy() throws Exception {
        if (this.channel != null) {
            this.channel.sendSignal("KILL");
            this.channel.disconnect();
        }
    }

    /*
     * Unable to fully structure code
     */
    public int waitFor() throws Exception {
        if (this.channel != null) ** GOTO lbl7
        throw new Exception("No command channel is connected.");
lbl-1000:
        // 1 sources

        {
            try {
                Thread.sleep(500L);
                continue;
            }
            catch (InterruptedException v0) {}
lbl7:
            // 3 sources

            ** while (this.channel.isConnected())
        }
lbl8:
        // 1 sources

        return this.channel.getExitStatus();
    }

    public void setEnv(byte[] name, byte[] value) {
        ((ChannelExec)this.channel).setEnv(name, value);
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(ChannelExec.class)) {
            return this.channel;
        }
        return null;
    }
}

