/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.api.impl;

import com.vmware.vide.rse.api.impl.Target;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.ITargetFile;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class TargetFile
implements ITargetFile {
    private final IHost host;
    private final IRemoteFileSubSystem subSystem;
    private IRemoteFile remoteFile;
    private final Target target;

    public TargetFile(Target target, IRemoteFile remoteFile) {
        this.target = target;
        this.remoteFile = remoteFile;
        this.host = target.getHost();
        this.subSystem = RemoteFileUtility.getFileSubSystem((IHost)this.host);
    }

    public boolean canRead() {
        return this.remoteFile.canRead();
    }

    public boolean canWrite() {
        return this.remoteFile.canWrite();
    }

    public void delete(IProgressMonitor monitor) throws Exception {
        this.subSystem.delete(this.remoteFile, monitor);
    }

    public boolean exists() {
        return this.remoteFile.exists();
    }

    public String getAbsolutePath() {
        return this.remoteFile.getAbsolutePath();
    }

    public String getCanonicalPath() {
        return this.remoteFile.getCanonicalPath();
    }

    public ITarget getTarget() {
        return this.target;
    }

    public String getParent() {
        return this.remoteFile.getParentPath();
    }

    public ITargetFile getParentTargetFile(IProgressMonitor monitor) {
        IRemoteFile parent = this.subSystem.getParentFolder(this.remoteFile, monitor);
        return new TargetFile(this.target, parent);
    }

    public boolean isDirectory() {
        return this.remoteFile.isDirectory();
    }

    public boolean isFile() {
        return this.remoteFile.isFile();
    }

    public long lastModified() {
        return this.remoteFile.getLastModified();
    }

    public long length() {
        return this.remoteFile.getLength();
    }

    public String[] list(IProgressMonitor monitor) throws Exception {
        IRemoteFile[] files = this.subSystem.list(this.remoteFile, monitor);
        ArrayList<String> results = new ArrayList<String>();
        IRemoteFile[] iRemoteFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFile file = iRemoteFileArray[n2];
            results.add(file.getName());
            ++n2;
        }
        return results.toArray(new String[results.size()]);
    }

    public ITargetFile[] listFiles(IProgressMonitor monitor) throws Exception {
        IRemoteFile[] files = this.subSystem.list(this.remoteFile, monitor);
        ArrayList<TargetFile> results = new ArrayList<TargetFile>();
        IRemoteFile[] iRemoteFileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IRemoteFile file = iRemoteFileArray[n2];
            results.add(new TargetFile(this.target, file));
            ++n2;
        }
        return results.toArray(new ITargetFile[results.size()]);
    }

    public boolean mkdir(IProgressMonitor monitor) throws Exception {
        if (this.exists()) {
            return false;
        }
        IRemoteFile result = this.subSystem.createFolder(this.remoteFile, monitor);
        if (result == null) {
            return false;
        }
        this.remoteFile = result;
        return true;
    }

    public boolean mkdirs(IProgressMonitor monitor) throws Exception {
        if (this.exists()) {
            return false;
        }
        IRemoteFile result = this.subSystem.createFolders(this.remoteFile, monitor);
        if (result == null) {
            return false;
        }
        this.remoteFile = result;
        return true;
    }
}

