/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.connector;

import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import com.vmware.vide.rse.connector.vIDESshConnectorServiceManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class vIDESshConnectorService
extends SshConnectorService {
    private static final Logger logger = LoggerFactory.getLogger(vIDESshConnectorService.class);

    public vIDESshConnectorService(IHost host) {
        super(host);
    }

    protected Session createSession(String username, String password, String hostname, int port, UserInfo wrapperUI, IProgressMonitor monitor) throws JSchException {
        UserInfoDelegate delegate = new UserInfoDelegate(wrapperUI);
        Session session = super.createSession(username, password, hostname, port, (UserInfo)delegate, monitor);
        if (vIDESshConnectorServiceManager.getInstance().getByPassKeyCheck()) {
            session.setConfig("StrictHostKeyChecking", "no");
        }
        return session;
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        super.internalConnect(monitor);
        SystemSignonInformation ssi = this.getSignonInformation();
        UserInfo info = this.getSession().getUserInfo();
        if (ssi != null && info != null) {
            String rsePassword = ssi.getPassword();
            String sshPassword = info.getPassword();
            if (!sshPassword.equals(rsePassword)) {
                IRSESystemType type = this.getHost().getSystemType();
                boolean persist = PasswordPersistenceManager.getInstance().passwordExists(type, this.getHostName(), this.getUserId());
                this.setPassword(this.getUserId(), sshPassword, persist, true);
            }
        }
    }

    public SystemSignonInformation getSignonInfo() {
        return this.getSignonInformation();
    }

    private class UserInfoDelegate
    implements UserInfo,
    UIKeyboardInteractive {
        UserInfo realInfo;

        private UserInfoDelegate(UserInfo info) {
            this.realInfo = info;
        }

        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            if (vIDESshConnectorServiceManager.getInstance().getSuppressPopups()) {
                if (prompt.length == 0) {
                    return new String[0];
                }
                logger.warn("SSH::promptKeyboardInteractiv: destination = {}, name = {}, instruction = {}, prompt = {}", new Object[]{destination, name, instruction, prompt});
                if (prompt.length == 1 && prompt[0].trim().equalsIgnoreCase("password:")) {
                    return new String[]{this.realInfo.getPassword()};
                }
                return new String[0];
            }
            return ((UIKeyboardInteractive)this.realInfo).promptKeyboardInteractive(destination, name, instruction, prompt, echo);
        }

        public String getPassphrase() {
            return this.realInfo.getPassphrase();
        }

        public String getPassword() {
            return this.realInfo.getPassword();
        }

        public boolean promptPassword(String message) {
            if (vIDESshConnectorServiceManager.getInstance().getSuppressPopups()) {
                logger.warn("SSH::promptPassword: {} ", (Object)message);
                return false;
            }
            return this.realInfo.promptPassword(message);
        }

        public boolean promptPassphrase(String message) {
            if (vIDESshConnectorServiceManager.getInstance().getSuppressPopups()) {
                logger.warn("SSH::promptPassphrase: {} ", (Object)message);
                return false;
            }
            return this.realInfo.promptPassphrase(message);
        }

        public boolean promptYesNo(String message) {
            if (vIDESshConnectorServiceManager.getInstance().getSuppressPopups()) {
                logger.warn("SSH::promptYesNo: {} ", (Object)message);
                return true;
            }
            return this.realInfo.promptYesNo(message);
        }

        public void showMessage(String message) {
            if (message != null && !message.isEmpty()) {
                if (vIDESshConnectorServiceManager.getInstance().getSuppressPopups()) {
                    logger.warn("SSH::showMessage {} ", (Object)message);
                } else {
                    this.realInfo.showMessage(message);
                }
            }
        }
    }
}

