/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vide.rse.model.VirtualMachineElement;
import com.vmware.vim25.HostRuntimeInfo;
import com.vmware.vim25.HostSystemConnectionState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.VirtualMachine;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class HostSystemElement
extends AbstractResource {
    private HostSystem hostSystem;
    private HostRuntimeInfo runtime;
    private boolean inCluster;
    private String name;

    public HostSystemElement(HostSystem hostSystem, ISubSystem parentSubSystem, boolean inCluster) {
        super(parentSubSystem);
        this.hostSystem = hostSystem;
        this.runtime = hostSystem.getRuntime();
        this.inCluster = inCluster;
    }

    public boolean hasChildren() {
        return !this.inCluster;
    }

    public Object[] getChildren(IProgressMonitor monitor) {
        ArrayList<VirtualMachineElement> list = new ArrayList<VirtualMachineElement>();
        try {
            VirtualMachine[] vms;
            VirtualMachine[] virtualMachineArray = vms = this.hostSystem.getVms();
            int n = vms.length;
            int n2 = 0;
            while (n2 < n) {
                VirtualMachine vm = virtualMachineArray[n2];
                list.add(new VirtualMachineElement(vm, this.getSubSystem()));
                ++n2;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list.toArray();
    }

    public HostSystemConnectionState getConnectionState() {
        return this.runtime.getConnectionState();
    }

    public String toString() {
        if (this.name == null) {
            this.name = this.hostSystem.getName();
        }
        return this.name;
    }
}

