/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vide.rse.model.PortGroupElement;
import com.vmware.vide.rse.subsystems.ResourcesSubSystem;
import com.vmware.vim25.HostPortGroup;
import com.vmware.vim25.HostVirtualSwitch;
import com.vmware.vim25.mo.HostNetworkSystem;
import com.vmware.vim25.mo.HostSystem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class VSwitchElement
extends AbstractResource {
    private HostVirtualSwitch virtualSwitch;

    public VSwitchElement(HostVirtualSwitch virtualSwitch, ISubSystem parentSubSystem) {
        super(parentSubSystem);
        this.virtualSwitch = virtualSwitch;
    }

    public String getName() {
        if (this.virtualSwitch != null) {
            return this.virtualSwitch.getName();
        }
        return null;
    }

    public int getNumPorts() {
        if (this.virtualSwitch != null) {
            return this.virtualSwitch.getNumPorts();
        }
        return 0;
    }

    public int getNumPortsAvailable() {
        if (this.virtualSwitch != null) {
            return this.virtualSwitch.getNumPortsAvailable();
        }
        return 0;
    }

    public Integer getMTU() {
        if (this.virtualSwitch != null) {
            return this.virtualSwitch.getMtu();
        }
        return null;
    }

    public List getUplinks() {
        if (this.virtualSwitch != null) {
            String[] uplinks = this.virtualSwitch.getPnic();
            ArrayList<String> pnicList = new ArrayList<String>();
            int i = 0;
            while (i < uplinks.length) {
                String name = uplinks[i].substring(uplinks[i].indexOf("PhysicalNic-") + 12);
                pnicList.add(name);
                ++i;
            }
            return pnicList;
        }
        return null;
    }

    public PortGroupElement[] getPortGroup() {
        HostPortGroup[] portGroup = null;
        try {
            HostSystem host = ((ResourcesSubSystem)this.getSubSystem()).getHostSystem();
            HostNetworkSystem hns = host.getHostNetworkSystem();
            portGroup = hns.getNetworkInfo().getPortgroup();
        }
        catch (Exception e) {
            System.out.println(e);
        }
        ArrayList<PortGroupElement> pgList = new ArrayList<PortGroupElement>();
        if (portGroup != null) {
            int i = 0;
            while (i < portGroup.length) {
                if (portGroup[i].getVswitch().equals(this.virtualSwitch.getKey())) {
                    pgList.add(new PortGroupElement(portGroup[i], this.getSubSystem()));
                }
                ++i;
            }
        }
        return pgList.toArray(new PortGroupElement[pgList.size()]);
    }

    public String toString() {
        return this.getName();
    }
}

