/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.model;

import com.vmware.vim25.FileFault;
import com.vmware.vim25.InsufficientResourcesFault;
import com.vmware.vim25.InvalidState;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.TaskInProgress;
import com.vmware.vim25.VirtualMachineConfigSummary;
import com.vmware.vim25.VirtualMachineConnectionState;
import com.vmware.vim25.VirtualMachineGuestSummary;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.VirtualMachineSummary;
import com.vmware.vim25.VirtualMachineToolsStatus;
import com.vmware.vim25.VmConfigFault;
import com.vmware.vim25.mo.Task;
import com.vmware.vim25.mo.VirtualMachine;
import java.rmi.RemoteException;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.ISubSystem;

public class VirtualMachineElement
extends AbstractResource {
    public static final String POWER_ON = "Power On";
    public static final String POWER_OFF = "Power Off";
    public static final String POWER_SUSPEND = "Suspend";
    public static final String POWER_RESET = "Reset";
    private VirtualMachineSummary summary;
    private VirtualMachineRuntimeInfo runtime;
    private VirtualMachineConfigSummary config;
    private VirtualMachine virtualMachine;
    private String name = null;

    public VirtualMachineElement(VirtualMachine vm, ISubSystem parentSubSystem) {
        super(parentSubSystem);
        this.virtualMachine = vm;
        this.summary = vm.getSummary();
        if (this.summary != null) {
            this.config = this.summary.getConfig();
            this.runtime = this.summary.getRuntime();
        }
    }

    public VirtualMachine getVirtualMachine() {
        return this.virtualMachine;
    }

    public String getName() {
        if (this.name == null && this.virtualMachine != null) {
            this.name = this.virtualMachine.getName();
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVmxPath() {
        if (this.config != null) {
            return this.config.getVmPathName();
        }
        return null;
    }

    public String getGuestId() {
        if (this.config != null) {
            return this.config.getGuestId();
        }
        return null;
    }

    public String getGuestFullName() {
        if (this.config != null) {
            return this.config.getGuestFullName();
        }
        return null;
    }

    public Integer getNumCpu() {
        if (this.config != null) {
            return this.config.getNumCpu();
        }
        return null;
    }

    public Integer getMemorySizeMB() {
        if (this.config != null) {
            return this.config.getMemorySizeMB();
        }
        return null;
    }

    public VirtualMachinePowerState getPowerState() {
        if (this.runtime != null) {
            return this.runtime.getPowerState();
        }
        return null;
    }

    public VirtualMachineConnectionState getConnectionState() {
        if (this.runtime != null) {
            return this.runtime.getConnectionState();
        }
        return null;
    }

    public void setPowerState(VirtualMachinePowerState powerState) {
        if (this.runtime != null) {
            this.runtime.setPowerState(powerState);
        }
    }

    public String getHostName() {
        VirtualMachineGuestSummary guest;
        if (this.summary != null && (guest = this.summary.getGuest()) != null) {
            return guest.getHostName();
        }
        return null;
    }

    public String getIpAddress() {
        VirtualMachineGuestSummary guest;
        if (this.summary != null && (guest = this.summary.getGuest()) != null) {
            return guest.getIpAddress();
        }
        return null;
    }

    public VirtualMachineToolsStatus getToolsStatus() {
        VirtualMachineGuestSummary guest;
        if (this.summary != null && (guest = this.summary.getGuest()) != null) {
            return guest.getToolsStatus();
        }
        return null;
    }

    public VirtualMachineRuntimeInfo getRuntime() {
        return this.runtime;
    }

    public Task getTask(String action) throws VmConfigFault, TaskInProgress, FileFault, InvalidState, InsufficientResourcesFault, RuntimeFault, RemoteException {
        if (action.equals(POWER_ON)) {
            return this.virtualMachine.powerOnVM_Task(null);
        }
        if (action.equals(POWER_OFF)) {
            return this.virtualMachine.powerOffVM_Task();
        }
        if (action.equals(POWER_SUSPEND)) {
            return this.virtualMachine.suspendVM_Task();
        }
        if (action.equals(POWER_RESET)) {
            return this.virtualMachine.resetVM_Task();
        }
        return null;
    }

    public String toString() {
        return this.getName();
    }
}

