/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.service;

import com.vmware.vide.rse.service.vIDEFileService;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class VMWBFileATTR {
    static final int ATTR_FILESIZE = 0;
    static final int ATTR_BLOCKS = 1;
    static final int ATTR_RAWMODE = 2;
    static final int ATTR_UID = 3;
    static final int ATTR_GID = 4;
    static final int ATTR_DEVICE = 5;
    static final int ATTR_INODE = 6;
    static final int ATTR_HARDLINK = 7;
    static final int ATTR_MADEVICE = 8;
    static final int ATTR_MIDEVICE = 9;
    static final int ATTR_ATIME = 10;
    static final int ATTR_MTIME = 11;
    static final int ATTR_CTIME = 12;
    static final int ATTR_IOBLOCK = 13;
    static final int NUM_OF_TOKENS = 14;
    static final int S_ISUID = 2048;
    static final int S_ISGID = 1024;
    static final int S_ISVTX = 512;
    static final int S_IRUSR = 256;
    static final int S_IWUSR = 128;
    static final int S_IXUSR = 64;
    static final int S_IREAD = 256;
    static final int S_IWRITE = 128;
    static final int S_IEXEC = 64;
    static final int S_IRGRP = 32;
    static final int S_IWGRP = 16;
    static final int S_IXGRP = 8;
    static final int S_IROTH = 4;
    static final int S_IWOTH = 2;
    static final int S_IXOTH = 1;
    static final int S_IFDIR = 16384;
    static final int S_IFLNK = 40960;
    private String[] buffer;
    private int permissions;
    private String filename;

    VMWBFileATTR(String name, String buf) throws Exception {
        this.filename = name;
        String tmpBuf = buf.trim();
        if (!tmpBuf.startsWith(this.filename)) {
            throw new Exception("Stat output is not compatible");
        }
        tmpBuf = tmpBuf.substring(this.filename.length()).trim();
        this.buffer = tmpBuf.split("\\s+");
        if (this.buffer.length < 14) {
            throw new Exception("Stat output is not compatible");
        }
        this.permissions = Integer.parseInt(this.buffer[2], 16);
    }

    public int getAccess() {
        return this.permissions & 0xFFF;
    }

    public String getFilename() {
        return this.filename;
    }

    public boolean isDir() {
        return (this.permissions & 0x4000) == 16384;
    }

    public boolean isLink() {
        return (this.permissions & 0xA000) == 40960;
    }

    public long getSize() {
        return Long.parseLong(this.buffer[0]);
    }

    public String getUId() {
        return this.buffer[3];
    }

    public String getGId() {
        return this.buffer[4];
    }

    public long getAtime() {
        return Long.parseLong(this.buffer[10]) * 1000L;
    }

    public long getMtime() {
        return Long.parseLong(this.buffer[11]) * 1000L;
    }

    public long getCtime() {
        return Long.parseLong(this.buffer[12]) * 1000L;
    }

    public String getMtimeString() {
        SimpleDateFormat df = new SimpleDateFormat();
        try {
            Date date = df.parse(this.buffer[11]);
            return date.toString();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getPermissionsString() {
        StringBuffer buf = new StringBuffer(10);
        if (this.isDir()) {
            buf.append('d');
        } else if (this.isLink()) {
            buf.append('l');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x100) != 0) {
            buf.append('r');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x80) != 0) {
            buf.append('w');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x800) != 0) {
            buf.append('s');
        } else if ((this.permissions & 0x40) != 0) {
            buf.append('x');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x20) != 0) {
            buf.append('r');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x10) != 0) {
            buf.append('w');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 0x400) != 0) {
            buf.append('s');
        } else if ((this.permissions & 8) != 0) {
            buf.append('x');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 4) != 0) {
            buf.append('r');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 2) != 0) {
            buf.append('w');
        } else {
            buf.append('-');
        }
        if ((this.permissions & 1) != 0) {
            buf.append('x');
        } else {
            buf.append('-');
        }
        return buf.toString();
    }

    public vIDEFileService.MinFileATTR getFileAttr() {
        return new vIDEFileService.MinFileATTR(this.isDir(), this.isLink(), this.getMtime(), this.getSize(), this.getPermissionsString(), this.getUId(), this.getGId());
    }

    public String toString() {
        return String.valueOf(this.getPermissionsString()) + " " + this.getUId() + " " + this.getGId() + " " + this.getSize() + " " + this.getMtimeString();
    }
}

