/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.service;

import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpProgressMonitor;
import com.vmware.vide.rse.service.VMWBFileATTR;
import com.vmware.vide.rse.service.VMWBFileChannel;
import com.vmware.vide.rse.service.VMWBLSEntry;
import com.vmware.vide.rse.util.RSEHelper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.services.ssh.SshServiceResources;
import org.eclipse.rse.internal.services.ssh.files.SftpFileService;
import org.eclipse.rse.internal.services.ssh.files.SftpHostFile;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.RemoteFileIOException;

public class vIDEFileService
extends SftpFileService {
    private boolean useCustomService = false;
    private VMWBFileChannel channel;
    private String userHome;
    private IHostFile home;
    private IHostFile root;
    private final IHost host;

    public vIDEFileService(ISshSessionProvider sessionProvider) {
        super(sessionProvider);
        this.host = ((IConnectorService)sessionProvider).getHost();
    }

    public void initService(IProgressMonitor monitor) throws SystemMessageException {
        Session session = this.getSessionProvider().getSession();
        if (this.host.getSystemType().getId().equals("vide.rse.systemtype.esx")) {
            try {
                this.useCustomService = !RSEHelper.isESX50OrHigher(this.host) && RSEHelper.isVisor(this.host);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.channel = new VMWBFileChannel(session);
        if (this.useCustomService) {
            try {
                this.userHome = this.channel.pwd();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            super.initService(monitor);
        }
    }

    public void uninitService(IProgressMonitor monitor) {
        if (!this.useCustomService) {
            super.uninitService(monitor);
        } else {
            this.userHome = null;
        }
        this.channel = null;
    }

    public boolean isConnected() {
        if (!this.useCustomService) {
            return super.isConnected();
        }
        return this.channel != null;
    }

    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        ArrayList<SftpHostFile> results;
        block21: {
            if (!this.useCustomService) {
                return super.internalFetch(parentPath, fileFilter, fileType, monitor);
            }
            if (fileFilter == null) {
                fileFilter = "*";
            }
            NamePatternMatcher filematcher = null;
            if (fileFilter.endsWith(",")) {
                String[] types = fileFilter.split(",");
                filematcher = new FileTypeMatcher(types, true);
            } else {
                filematcher = new NamePatternMatcher(fileFilter, true, true);
            }
            results = new ArrayList<SftpHostFile>();
            SubProgressMonitor subMonitor = null;
            try {
                try {
                    if (monitor != null) {
                        monitor.beginTask("list", 100);
                    }
                    Vector vv = this.channel.list(PathUtility.enQuoteUnix((String)parentPath));
                    this.progressTick(monitor, 40);
                    if (vv.size() > 1 && monitor != null) {
                        subMonitor = new SubProgressMonitor(monitor, 60);
                        subMonitor.beginTask(null, vv.size());
                    }
                    int ii = 0;
                    while (ii < vv.size()) {
                        VMWBLSEntry lsEntry;
                        String fileName;
                        Object obj = vv.elementAt(ii);
                        if (obj instanceof VMWBLSEntry && !".".equals(fileName = (lsEntry = (VMWBLSEntry)obj).getFilename()) && !"..".equals(fileName) && filematcher.matches(fileName)) {
                            SftpHostFile node = this.createHostFile(parentPath, fileName, lsEntry.getFileAttr());
                            this.progressTick((IProgressMonitor)subMonitor, 1);
                            if (this.isRightType(fileType, (IHostFile)node)) {
                                results.add(node);
                            }
                        }
                        ++ii;
                    }
                }
                catch (Exception e) {
                    if (this.checkSessionConnected()) {
                        throw new SystemOperationFailedException("com.vmware.vide.rse", "Session Lost", e);
                    }
                    if (subMonitor != null) {
                        subMonitor.done();
                    }
                    if (monitor != null) {
                        monitor.done();
                    }
                    break block21;
                }
            }
            catch (Throwable throwable) {
                if (subMonitor != null) {
                    subMonitor.done();
                }
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            if (subMonitor != null) {
                subMonitor.done();
            }
            if (monitor != null) {
                monitor.done();
            }
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public void setFilePermissions(IHostFile file, IHostFilePermissions permissions, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            super.setFilePermissions(file, permissions, monitor);
            return;
        }
        String path = file.getAbsolutePath();
        try {
            this.channel.chmod(permissions.getPermissionBits(), PathUtility.enQuoteUnix((String)path));
        }
        catch (Exception e) {
            if (e.getLocalizedMessage().contains("No such file")) {
                throw new SystemElementNotFoundException(path, "chmod");
            }
            throw new RemoteFileIOException(e);
        }
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            super.copy(srcParent, srcName, tgtParent, tgtName, monitor);
            return;
        }
        String fullPathOld = PathUtility.enQuoteUnix((String)this.concat(srcParent, srcName));
        String fullPathNew = PathUtility.enQuoteUnix((String)this.concat(tgtParent, tgtName));
        try {
            this.channel.runCommand("cp -Rp " + fullPathOld + ' ' + fullPathNew, monitor);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        String path = PathUtility.enQuoteUnix((String)this.concat(remoteParent, fileName));
        if (!this.useCustomService) {
            return super.createFile(remoteParent, fileName, monitor);
        }
        try {
            this.channel.runCommand("touch " + path, monitor);
            return this.getFile(remoteParent, fileName, monitor);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            return super.createFolder(remoteParent, folderName, monitor);
        }
        String path = PathUtility.enQuoteUnix((String)this.concat(remoteParent, folderName));
        try {
            this.channel.runCommand("mkdir " + path, monitor);
            return this.getFile(remoteParent, folderName, monitor);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            super.delete(remoteParent, fileName, monitor);
            return;
        }
        String fullPath = this.concat(remoteParent, fileName);
        try {
            VMWBFileATTR attr = null;
            try {
                attr = this.channel.stat(fullPath);
            }
            catch (Exception exception) {}
            if (attr == null) {
                throw new SystemElementNotFoundException(fullPath, "delete");
            }
            if (attr.isDir()) {
                this.channel.runCommand("rm -rf " + PathUtility.enQuoteUnix((String)fullPath), monitor);
            } else {
                this.channel.runCommand("rm -f " + PathUtility.enQuoteUnix((String)fullPath), monitor);
            }
        }
        catch (Exception e) {
            if (e instanceof RemoteFileIOException) {
                throw (RemoteFileIOException)e;
            }
            throw new RemoteFileIOException(e);
        }
    }

    public void download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        String srcFile = PathUtility.enQuoteUnix((String)this.concat(remoteParent, remoteFile));
        try {
            File localParentFile;
            if (!this.checkSessionConnected()) {
                throw new IOException(SshServiceResources.SftpFileService_Error_JschSessionLost);
            }
            if (!localFile.exists() && !(localParentFile = localFile.getParentFile()).exists()) {
                localParentFile.mkdirs();
            }
            this.channel.ScpFrom(srcFile, localFile.getAbsolutePath(), (SftpProgressMonitor)(monitor != null ? new SftpFileService.MyProgressMonitor(monitor) : null));
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    public IHostFile getFile(String remoteParent, String name, IProgressMonitor monitor) throws SystemMessageException {
        SftpHostFile node;
        block4: {
            if (!this.useCustomService) {
                return super.getFile(remoteParent, name, monitor);
            }
            node = null;
            try {
                VMWBFileATTR attrs = this.channel.stat(this.concat(remoteParent, name));
                node = this.createHostFile(remoteParent, name, attrs.getFileAttr());
            }
            catch (Exception e) {
                if (e.getLocalizedMessage().contains("No such file")) break block4;
                throw new RemoteFileIOException(e);
            }
        }
        if (node == null) {
            boolean isRoot = remoteParent == null || remoteParent.length() == 0;
            node = new SftpHostFile(isRoot ? null : remoteParent, name, false, isRoot, false, 0L, 0L);
            node.setExists(false);
        }
        return node;
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        if (!this.useCustomService) {
            return super.getRoots(monitor);
        }
        if (this.root == null) {
            try {
                this.root = this.getFile(null, "/", monitor);
            }
            catch (SystemMessageException systemMessageException) {}
            if (this.root == null) {
                this.root = new SftpHostFile(null, "/", true, true, false, 0L, 0L);
            }
        }
        return new IHostFile[]{this.root};
    }

    public IHostFile getUserHome() {
        if (!this.useCustomService) {
            return super.getUserHome();
        }
        if (this.home == null) {
            File tmp = new File(this.userHome);
            String parent = tmp.getParent();
            String name = tmp.getName();
            try {
                if ((parent == null || parent.isEmpty()) && (name == null || name.isEmpty())) {
                    parent = null;
                    name = this.userHome;
                }
                this.home = this.getFile(parent, name, null);
            }
            catch (SystemMessageException systemMessageException) {
                this.home = new SftpHostFile(null, this.userHome, true, true, false, 0L, 0L);
            }
        }
        return this.home;
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            super.move(srcParent, srcName, tgtParent, tgtName, monitor);
            return;
        }
        String oldPath = PathUtility.enQuoteUnix((String)this.concat(srcParent, srcName));
        String newPath = PathUtility.enQuoteUnix((String)this.concat(tgtParent, tgtName));
        try {
            this.channel.runCommand("mv " + oldPath + " " + newPath, monitor);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            super.rename(remoteParent, oldName, newName, monitor);
            return;
        }
        this.move(remoteParent, oldName, remoteParent, newName, monitor);
    }

    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            super.setLastModified(parent, name, timestamp, monitor);
            return;
        }
    }

    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        if (!this.useCustomService) {
            super.setReadOnly(parent, name, readOnly, monitor);
            return;
        }
        String path = this.concat(parent, name);
        try {
            int oldMode;
            VMWBFileATTR attr = this.channel.stat(path);
            int newMode = oldMode = attr.getAccess();
            newMode = readOnly ? (newMode &= 0xFFFFFF6D) : (newMode |= 0x80);
            if (newMode != oldMode) {
                this.channel.chmod(newMode, PathUtility.enQuoteUnix((String)path));
            }
        }
        catch (Exception e) {
            if (e.getLocalizedMessage().contains("No such file")) {
                throw new SystemElementNotFoundException(path, "setReadOnly");
            }
            throw new RemoteFileIOException(e);
        }
    }

    public void upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        String dstFile = remoteFile == null ? remoteParent : this.concat(remoteParent, remoteFile);
        dstFile = PathUtility.enQuoteUnix((String)dstFile);
        try {
            if (!this.checkSessionConnected()) {
                throw new IOException(SshServiceResources.SftpFileService_Error_JschSessionLost);
            }
            this.channel.ScpTo(localFile.getAbsolutePath(), dstFile, (SftpProgressMonitor)(monitor != null ? new SftpFileService.MyProgressMonitor(monitor) : null));
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
    }

    private SftpHostFile createHostFile(String parentPath, String fileName, MinFileATTR attr) {
        String perms;
        boolean isRoot;
        String canonicalPath;
        String linkTarget;
        VMWBFileATTR linkAttr;
        block16: {
            linkAttr = null;
            linkTarget = null;
            canonicalPath = null;
            boolean bl = isRoot = parentPath == null || parentPath.length() == 0;
            if (attr.isLink() && !isRoot) {
                try {
                    String fullPath;
                    int idx = fileName.indexOf("->");
                    if (idx > 0) {
                        linkTarget = fileName.substring(idx + 2).trim();
                        fileName = fileName.substring(0, idx).trim();
                        fullPath = this.concat(parentPath, fileName);
                    } else {
                        fullPath = this.concat(parentPath, fileName);
                        linkTarget = this.channel.readlink(PathUtility.enQuoteUnix((String)fullPath));
                    }
                    if (linkTarget != null && !linkTarget.equals(fullPath)) {
                        linkAttr = !linkTarget.startsWith("/") ? this.channel.stat(this.concat(parentPath, linkTarget)) : this.channel.stat(linkTarget);
                        if (linkAttr.isDir()) {
                            canonicalPath = linkTarget.startsWith("/") ? linkTarget : this.concat(parentPath, linkTarget);
                        }
                    } else {
                        linkTarget = null;
                    }
                }
                catch (Exception e) {
                    if (!e.getLocalizedMessage().contains("No such file")) break block16;
                    linkTarget = linkTarget == null ? ":dangling link" : ":dangling link:" + linkTarget;
                }
            }
        }
        SftpHostFile node = new SftpHostFile(isRoot ? null : parentPath, fileName, linkAttr == null ? attr.isDir() : linkAttr.isDir(), isRoot, attr.isLink(), attr.getMtime(), attr.getSize());
        if (linkTarget != null) {
            node.setLinkTarget(linkTarget);
        }
        if (canonicalPath != null) {
            node.setCanonicalPath(canonicalPath);
        }
        String string = perms = linkAttr == null ? attr.getPermissionsString() : linkAttr.getPermissionsString();
        if (perms.indexOf(114, 1) <= 0) {
            node.setReadable(false);
        }
        if (perms.indexOf(119, 1) <= 0) {
            node.setWritable(false);
        }
        if (node.isDirectory()) {
            if (perms.indexOf(120, 1) <= 0) {
                node.setWritable(false);
            }
        } else if (perms.indexOf(120, 1) > 0) {
            node.setExecutable(true);
        }
        HostFilePermissions permissions = new HostFilePermissions(perms, attr.getUid(), attr.getGid());
        node.setPermissions((IHostFilePermissions)permissions);
        return node;
    }

    public static class MinFileATTR {
        private final boolean isDir;
        private final boolean isLink;
        private final long mTime;
        private final long size;
        private final String permission;
        private final String uID;
        private final String gID;

        public MinFileATTR(boolean dir, boolean link, long mtime, long size, String perm, String uid, String gid) {
            this.isDir = dir;
            this.isLink = link;
            this.mTime = mtime;
            this.size = size;
            this.permission = perm;
            this.uID = uid;
            this.gID = gid;
        }

        public boolean isDir() {
            return this.isDir;
        }

        public boolean isLink() {
            return this.isLink;
        }

        public long getSize() {
            return this.size;
        }

        public long getMtime() {
            return this.mTime;
        }

        public String getPermissionsString() {
            return this.permission;
        }

        public String getUid() {
            return this.uID;
        }

        public String getGid() {
            return this.gID;
        }
    }
}

