/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.service;

import com.vmware.vide.rse.RSEResources;
import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.model.DataStoreElement;
import com.vmware.vide.rse.model.HBAElement;
import com.vmware.vide.rse.model.LunElement;
import com.vmware.vide.rse.model.PNicElement;
import com.vmware.vide.rse.model.VSwitchElement;
import com.vmware.vide.rse.model.VirtualMachineElement;
import com.vmware.vide.rse.service.ISDKService;
import com.vmware.vide.rse.subsystems.ResourcesSubSystem;
import com.vmware.vide.rse.util.RSEHelper;
import com.vmware.vim25.HostHostBusAdapter;
import com.vmware.vim25.HostVirtualSwitch;
import com.vmware.vim25.InvalidProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.ObjectUpdate;
import com.vmware.vim25.ObjectUpdateKind;
import com.vmware.vim25.PhysicalNic;
import com.vmware.vim25.PropertyChange;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertyFilterUpdate;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RequestCanceled;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.ScsiLun;
import com.vmware.vim25.UpdateSet;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.WaitOptions;
import com.vmware.vim25.mo.Datastore;
import com.vmware.vim25.mo.HostNetworkSystem;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.InventoryNavigator;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.PropertyCollector;
import com.vmware.vim25.mo.PropertyFilter;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import com.vmware.vim25.mo.util.PropertyCollectorUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterReference;
import org.eclipse.rse.core.model.ISystemContentsType;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.SystemChildrenContentsType;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.AbstractService;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class vIDESDKService
extends AbstractService
implements ISDKService {
    private static final String MONITER_VM = "VirtualMachine";
    private static final String PROPERTY_NAME = "name";
    private static final String PROPERTY_POWERSTATE = "runtime.powerState";
    private ResourcesConnectorService connector;
    private ServiceInstance serviceInstance;
    private HostSystem hostSystem;
    private ResourcesSubSystem subsystem;
    private PropertyMonitor eventMonitor;
    private PropertyCollector collector;
    private PropertyFilter filter;

    public vIDESDKService(ResourcesConnectorService conn) {
        this.connector = conn;
    }

    public void initService(IProgressMonitor monitor) throws SystemMessageException {
        this.serviceInstance = this.connector.getServiceInstance();
        try {
            this.hostSystem = this.getHostSystem();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        PropertySpec pSpec = new PropertySpec();
        pSpec.setAll(new Boolean(false));
        pSpec.setPathSet(new String[]{PROPERTY_NAME, PROPERTY_POWERSTATE});
        pSpec.setType(MONITER_VM);
        ObjectSpec oSpec = new ObjectSpec();
        oSpec.setObj(this.serviceInstance.getRootFolder().getMOR());
        oSpec.setSkip(new Boolean(true));
        oSpec.setSelectSet(PropertyCollectorUtil.buildFullTraversal());
        PropertyFilterSpec fSpec = new PropertyFilterSpec();
        fSpec.setPropSet(new PropertySpec[]{pSpec});
        fSpec.setObjectSet(new ObjectSpec[]{oSpec});
        try {
            this.collector = this.serviceInstance.getPropertyCollector();
            this.filter = this.collector.createFilter(fSpec, true);
            this.eventMonitor = new PropertyMonitor("Event Linstener");
            this.eventMonitor.setSystem(true);
            this.eventMonitor.schedule();
        }
        catch (Exception e) {
            if (this.collector != null) {
                this.collector = null;
            }
            e.printStackTrace();
        }
        this.subsystem = RSEHelper.getResourcesSubSystem(this.connector.getHost());
    }

    public void uninitService(IProgressMonitor monitor) {
        try {
            if (this.collector != null) {
                this.collector.cancelWaitForUpdates();
                if (this.filter != null) {
                    this.filter.destroyPropertyFilter();
                }
            }
        }
        catch (Exception exception) {}
        if (this.eventMonitor != null) {
            this.eventMonitor.cancel();
        }
        this.serviceInstance = null;
        this.hostSystem = null;
        this.subsystem = null;
    }

    @Override
    public HostSystem getHostSystem() throws InvalidProperty, RuntimeFault, RemoteException {
        ManagedEntity[] hosts;
        if (this.hostSystem == null && (hosts = new InventoryNavigator((ManagedEntity)this.serviceInstance.getRootFolder()).searchManagedEntities((String[][])new String[][]{{"HostSystem", PROPERTY_NAME}}, true)) != null && hosts.length > 0) {
            this.hostSystem = (HostSystem)hosts[0];
        }
        return this.hostSystem;
    }

    @Override
    public VirtualMachineElement[] getVirtualMachineList() {
        ManagedEntity[] vms = null;
        try {
            vms = new InventoryNavigator((ManagedEntity)this.serviceInstance.getRootFolder()).searchManagedEntities((String[][])new String[][]{{RSEResources.TypeInfo_VirtualMachine, PROPERTY_NAME}}, true);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                this.connector.handleSessionLost();
            }
            e.printStackTrace();
        }
        ArrayList<VirtualMachineElement> vmList = new ArrayList<VirtualMachineElement>();
        if (vms != null) {
            int i = 0;
            while (i < vms.length) {
                vmList.add(new VirtualMachineElement((VirtualMachine)vms[i], this.subsystem));
                ++i;
            }
        }
        return vmList.toArray(new VirtualMachineElement[vmList.size()]);
    }

    @Override
    public LunElement[] getSCSILunList() {
        ScsiLun[] scsiLuns = null;
        try {
            scsiLuns = this.hostSystem.getConfig().getStorageDevice().getScsiLun();
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                this.connector.handleSessionLost();
            }
            e.printStackTrace();
        }
        ArrayList<LunElement> lunList = new ArrayList<LunElement>();
        if (scsiLuns != null) {
            int i = 0;
            while (i < scsiLuns.length) {
                lunList.add(new LunElement(scsiLuns[i], this.subsystem));
                ++i;
            }
        }
        return lunList.toArray(new LunElement[lunList.size()]);
    }

    @Override
    public HBAElement[] getHBAList() {
        HostHostBusAdapter[] hbas = null;
        try {
            hbas = this.hostSystem.getConfig().getStorageDevice().getHostBusAdapter();
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                this.connector.handleSessionLost();
            }
            e.printStackTrace();
        }
        ArrayList<HBAElement> hbaList = new ArrayList<HBAElement>();
        if (hbas != null) {
            int i = 0;
            while (i < hbas.length) {
                hbaList.add(new HBAElement(hbas[i], this.subsystem));
                ++i;
            }
        }
        return hbaList.toArray(new HBAElement[hbaList.size()]);
    }

    @Override
    public DataStoreElement[] getDataStoreList() {
        Datastore[] dataStores = null;
        try {
            dataStores = this.hostSystem.getDatastores();
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                this.connector.handleSessionLost();
            }
            e.printStackTrace();
        }
        ArrayList<DataStoreElement> dsList = new ArrayList<DataStoreElement>();
        if (dataStores != null) {
            int i = 0;
            while (i < dataStores.length) {
                dsList.add(new DataStoreElement(dataStores[i], this.subsystem));
                ++i;
            }
        }
        return dsList.toArray(new DataStoreElement[dsList.size()]);
    }

    @Override
    public VSwitchElement[] getVSwtichList() {
        HostVirtualSwitch[] vses = null;
        try {
            HostNetworkSystem hns = this.hostSystem.getHostNetworkSystem();
            vses = hns.getNetworkInfo().getVswitch();
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                this.connector.handleSessionLost();
            }
            e.printStackTrace();
        }
        ArrayList<VSwitchElement> vsList = new ArrayList<VSwitchElement>();
        if (vses != null) {
            int i = 0;
            while (i < vses.length) {
                vsList.add(new VSwitchElement(vses[i], this.subsystem));
                ++i;
            }
        }
        return vsList.toArray(new VSwitchElement[vsList.size()]);
    }

    @Override
    public PNicElement[] getPNicList() {
        PhysicalNic[] pnics = null;
        try {
            HostNetworkSystem hns = this.hostSystem.getHostNetworkSystem();
            pnics = hns.getNetworkInfo().getPnic();
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                this.connector.handleSessionLost();
            }
            e.printStackTrace();
        }
        ArrayList<PNicElement> pnicList = new ArrayList<PNicElement>();
        if (pnics != null) {
            int i = 0;
            while (i < pnics.length) {
                pnicList.add(new PNicElement(pnics[i], this.subsystem));
                ++i;
            }
        }
        return pnicList.toArray(new PNicElement[pnicList.size()]);
    }

    class PropertyMonitor
    extends Job {
        public PropertyMonitor(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            String version = "";
            do {
                try {
                    WaitOptions waitOptions = new WaitOptions();
                    waitOptions.maxWaitSeconds = 0;
                    UpdateSet update = vIDESDKService.this.collector.waitForUpdatesEx(version, waitOptions);
                    if (update == null || update.getFilterSet() == null) continue;
                    version = update.getVersion();
                    this.handleUpdate(update);
                }
                catch (Exception e) {
                    if (e instanceof RequestCanceled) break;
                    if (e instanceof RemoteException) {
                        e.printStackTrace();
                        vIDESDKService.this.collector = null;
                        vIDESDKService.this.connector.handleSessionLost();
                        break;
                    }
                    e.printStackTrace();
                }
            } while (!monitor.isCanceled());
            return Status.OK_STATUS;
        }

        private void handleUpdate(UpdateSet update) {
            PropertyFilterUpdate[] pfus;
            ISystemFilterReference ref = this.getFilterReference(RSEResources.VMList_FilterType);
            if (ref.getContents((ISystemContentsType)SystemChildrenContentsType.getInstance()) == null) {
                return;
            }
            PropertyFilterUpdate[] propertyFilterUpdateArray = pfus = update.getFilterSet();
            int n = pfus.length;
            int n2 = 0;
            while (n2 < n) {
                ObjectUpdate[] ous;
                PropertyFilterUpdate pfu = propertyFilterUpdateArray[n2];
                ObjectUpdate[] objectUpdateArray = ous = pfu.getObjectSet();
                int n3 = ous.length;
                int n4 = 0;
                while (n4 < n3) {
                    ObjectUpdate ou = objectUpdateArray[n4];
                    this.handleObjectUpdate(ou, ref);
                    ++n4;
                }
                ++n2;
            }
        }

        private void handleObjectUpdate(ObjectUpdate oUpdate, ISystemFilterReference ref) {
            block10: {
                Object[] objects;
                ISystemRegistry registry;
                ManagedObjectReference mor;
                block12: {
                    block11: {
                        mor = oUpdate.getObj();
                        if (mor == null || !mor.getType().equals(vIDESDKService.MONITER_VM)) {
                            return;
                        }
                        registry = RSECorePlugin.getTheSystemRegistry();
                        objects = ref.getContents((ISystemContentsType)SystemChildrenContentsType.getInstance());
                        if (oUpdate.getKind() != ObjectUpdateKind.enter) break block11;
                        ManagedObject mo = MorUtil.createExactManagedObject((ServerConnection)vIDESDKService.this.serviceInstance.getServerConnection(), (ManagedObjectReference)mor);
                        if (!(mo instanceof VirtualMachine)) {
                            return;
                        }
                        VirtualMachineElement object = new VirtualMachineElement((VirtualMachine)mo, vIDESDKService.this.subsystem);
                        VirtualMachineElement[] vList = new VirtualMachineElement[objects.length + 1];
                        System.arraycopy(objects, 0, vList, 0, objects.length);
                        vList[objects.length] = object;
                        ref.setContents((ISystemContentsType)SystemChildrenContentsType.getInstance(), (Object[])vList);
                        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)object, 50, (Object)ref));
                        break block10;
                    }
                    if (oUpdate.getKind() != ObjectUpdateKind.leave) break block12;
                    int i = 0;
                    while (i < objects.length) {
                        if (objects[i] instanceof VirtualMachineElement && ((VirtualMachineElement)((Object)objects[i])).getVirtualMachine().getMOR().equals(mor)) {
                            VirtualMachineElement[] list = new VirtualMachineElement[objects.length - 1];
                            System.arraycopy(objects, 0, list, 0, i);
                            System.arraycopy(objects, i + 1, list, i, objects.length - i - 1);
                            ref.setContents((ISystemContentsType)SystemChildrenContentsType.getInstance(), (Object[])list);
                            registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(objects[i], 55, (Object)ref));
                            break block10;
                        }
                        ++i;
                    }
                    break block10;
                }
                if (oUpdate.getKind() != ObjectUpdateKind.modify) break block10;
                Object[] objectArray = objects;
                int n = objects.length;
                int n2 = 0;
                while (n2 < n) {
                    Object object = objectArray[n2];
                    if (object instanceof VirtualMachineElement && ((VirtualMachineElement)((Object)object)).getVirtualMachine().getMOR().equals(mor)) {
                        PropertyChange[] pcs;
                        VirtualMachineElement elem = (VirtualMachineElement)((Object)object);
                        PropertyChange[] propertyChangeArray = pcs = oUpdate.getChangeSet();
                        int n3 = pcs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            PropertyChange pc = propertyChangeArray[n4];
                            String name = pc.getName();
                            Object value = pc.getVal();
                            if (name.equals(vIDESDKService.PROPERTY_NAME) && value != null) {
                                elem.setName(value.toString());
                            } else if (name.equals(vIDESDKService.PROPERTY_POWERSTATE) && value instanceof VirtualMachinePowerState) {
                                elem.setPowerState((VirtualMachinePowerState)value);
                            }
                            ++n4;
                        }
                        registry.fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent(object, 82, (Object)ref));
                        break;
                    }
                    ++n2;
                }
            }
        }

        private ISystemFilterReference getFilterReference(String type) {
            ISystemFilterPoolReferenceManager manager = vIDESDKService.this.subsystem.getFilterPoolReferenceManager();
            ISystemFilterPool[] pools = manager.getReferencedSystemFilterPools();
            int i = 0;
            while (i < pools.length) {
                ISystemFilter[] filters;
                ISystemFilter[] iSystemFilterArray = filters = pools[i].getFilters();
                int n = filters.length;
                int n2 = 0;
                while (n2 < n) {
                    ISystemFilter filter = iSystemFilterArray[n2];
                    if (filter.getType().equals(type)) {
                        return manager.getSystemFilterReference((ISubSystem)vIDESDKService.this.subsystem, filter);
                    }
                    ++n2;
                }
                ++i;
            }
            return null;
        }
    }
}

