/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.subsystems;

import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.connector.vIDESshConnectorService;
import com.vmware.vide.rse.model.DataCenterElement;
import com.vmware.vide.rse.model.FolderElement;
import com.vmware.vide.rse.service.ISDKService;
import com.vmware.vim25.mo.Datacenter;
import com.vmware.vim25.mo.Folder;
import com.vmware.vim25.mo.ManagedEntity;
import com.vmware.vim25.mo.ServiceInstance;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;
import org.eclipse.rse.core.subsystems.AbstractResource;
import org.eclipse.rse.core.subsystems.CommunicationsEvent;
import org.eclipse.rse.core.subsystems.ICommunicationsListener;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

public class InventorySubSystem
extends SubSystem
implements ICommunicationsListener {
    private ISDKService service;

    public InventorySubSystem(IHost host, IConnectorService connectorService, ISDKService service) {
        super(host, connectorService);
        this.service = service;
    }

    public void initializeSubSystem(IProgressMonitor monitor) throws SystemMessageException {
        super.initializeSubSystem(monitor);
    }

    public void uninitializeSubSystem(IProgressMonitor monitor) {
        super.uninitializeSubSystem(monitor);
    }

    public void communicationsStateChange(CommunicationsEvent e) {
    }

    public boolean isPassiveCommunicationsListener() {
        return false;
    }

    public Object[] resolveFilterString(String filterString, IProgressMonitor monitor) throws Exception {
        return super.resolveFilterString(filterString, monitor);
    }

    public Object[] getChildren() {
        try {
            ManagedEntity[] entities;
            if (!this.isConnected()) {
                this.connect((IProgressMonitor)new NullProgressMonitor(), false);
            }
            ServiceInstance si = ((ResourcesConnectorService)this.getConnectorService()).getServiceInstance();
            Folder root = si.getRootFolder();
            ArrayList<AbstractResource> list = new ArrayList<AbstractResource>();
            ManagedEntity[] managedEntityArray = entities = root.getChildEntity();
            int n = entities.length;
            int n2 = 0;
            while (n2 < n) {
                ManagedEntity entity = managedEntityArray[n2];
                if (entity instanceof Folder) {
                    list.add(new FolderElement((Folder)entity, (ISubSystem)this));
                } else if (entity instanceof Datacenter) {
                    list.add(new DataCenterElement((Datacenter)entity, (ISubSystem)this));
                } else {
                    System.out.println("Unknown entity " + entity.getName());
                }
                ++n2;
            }
            return list.toArray();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean promptForPassword(boolean force) throws Exception {
        SystemSignonInformation info;
        String password;
        IConnectorService sconnector;
        IRemoteFileSubSystem fss;
        IConnectorService rconnector = this.getConnectorService();
        if (!rconnector.hasPassword(true) && (fss = RemoteFileUtility.getFileSubSystem((IHost)this._host)) != null && fss.isConnected() && (sconnector = fss.getConnectorService()) instanceof vIDESshConnectorService && (password = (info = ((vIDESshConnectorService)sconnector).getSignonInfo()).getPassword()) != null) {
            rconnector.setPassword(this.getUserId(), password, false, false);
        }
        return super.promptForPassword(force);
    }
}

