/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.actions;

import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.model.VirtualMachineElement;
import com.vmware.vide.rse.ui.views.VNCViewerView;
import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.OptionValue;
import com.vmware.vim25.VirtualMachineConfigInfo;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.mo.HostSystem;
import com.vmware.vim25.mo.ManagedObject;
import com.vmware.vim25.mo.ServerConnection;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.VirtualMachine;
import com.vmware.vim25.mo.util.MorUtil;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;

public class LaunchRemoteDisplay
extends SystemBaseAction {
    public static final String vncEnabled = "RemoteDisplay.vnc.enabled";
    public static final String vncPort = "RemoteDisplay.vnc.port";

    public LaunchRemoteDisplay(String text, String tooltip, ImageDescriptor image, Shell parent) {
        super(text, tooltip, image, parent);
    }

    public void run() {
        Object object = this.getFirstSelection();
        if (object instanceof VirtualMachineElement) {
            VirtualMachineElement vmElement = (VirtualMachineElement)((Object)object);
            IHost host = vmElement.getSubSystem().getHost();
            if (!host.getSystemType().getId().equals("vide.rse.systemtype.esx") && !host.getSystemType().getId().equals("vide.rse.systemtype.vc")) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"This feature is only available on ESX or Virtual Center");
                return;
            }
            if (!vmElement.getPowerState().equals((Object)VirtualMachinePowerState.poweredOn)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Virtual Machine is not running. Power on the VM and retry");
                return;
            }
            IWorkbench workbench = PlatformUI.getWorkbench();
            IWorkbenchPage page = workbench.getActiveWorkbenchWindow().getActivePage();
            IViewPart view = null;
            try {
                view = page.showView("vide.rse.view.vnc", vmElement.getName(), 1);
                page.bringToTop((IWorkbenchPart)view);
            }
            catch (PartInitException e) {
                e.printStackTrace();
            }
            if (view instanceof VNCViewerView) {
                ((VNCViewerView)view).setPartName(vmElement.getName());
                ConnectVNC job = new ConnectVNC(host, vmElement.getVirtualMachine(), (VNCViewerView)view);
                job.setUser(true);
                job.schedule();
            }
            HttpLogger.logActivity((String)"rse", (String)"RemoteDisplay");
        }
    }

    class ConnectVNC
    extends Job {
        private IHost host;
        private VirtualMachine vm;
        private VNCViewerView vnc;
        private boolean enabled;
        private int port;

        public ConnectVNC(IHost host, VirtualMachine vm, VNCViewerView view) {
            super("Remote Display : " + vm.getName());
            this.enabled = false;
            this.port = -1;
            this.host = host;
            this.vm = vm;
            this.vnc = view;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (this.vnc.getSWTRemoteDisplay().isActive()) {
                return Status.OK_STATUS;
            }
            monitor.beginTask("Connecting to " + this.vm.getName(), -1);
            try {
                this.CheckRemoteDisplayConfig();
                if (!this.enabled || this.port == -1) {
                    Status status = new Status(4, "com.vmware.vide.rse", "Remote Display is not enabled for " + this.vm.getName());
                    return status;
                }
                String hostName = this.getHostName();
                if (hostName == null) {
                    Status status = new Status(4, "com.vmware.vide.rse", "Failed to retrieve host information for " + this.vm.getName());
                    return status;
                }
                try {
                    this.vnc.start(hostName, this.port, "VNC 3.8", null, false, monitor);
                }
                catch (Exception e) {
                    Status status;
                    Status status2 = status = new Status(4, "com.vmware.vide.rse", "Failed to connect to Remote Display on " + this.vm.getName(), (Throwable)e);
                    return status2;
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }

        private void CheckRemoteDisplayConfig() {
            OptionValue[] values;
            VirtualMachineConfigInfo config = this.vm.getConfig();
            OptionValue[] optionValueArray = values = config.getExtraConfig();
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                OptionValue value = optionValueArray[n2];
                if (value.getKey().equals(LaunchRemoteDisplay.vncEnabled)) {
                    if (value.getValue().equals("true")) {
                        this.enabled = true;
                    }
                } else if (value.getKey().equals(LaunchRemoteDisplay.vncPort)) {
                    this.port = Integer.parseInt((String)value.getValue());
                }
                ++n2;
            }
        }

        private String getHostName() {
            ManagedObject mo;
            ManagedObjectReference mor;
            if (this.host.getSystemType().getId().equals("vide.rse.systemtype.esx")) {
                return this.host.getHostName();
            }
            IConnectorService[] connectors = this.host.getConnectorServices();
            ServiceInstance si = null;
            IConnectorService[] iConnectorServiceArray = connectors;
            int n = connectors.length;
            int n2 = 0;
            while (n2 < n) {
                IConnectorService connector = iConnectorServiceArray[n2];
                if (connector instanceof ResourcesConnectorService) {
                    si = ((ResourcesConnectorService)connector).getServiceInstance();
                    break;
                }
                ++n2;
            }
            if (si != null && (mor = this.vm.getRuntime().getHost()) != null && mor.getType().equals("HostSystem") && (mo = MorUtil.createExactManagedObject((ServerConnection)si.getServerConnection(), (ManagedObjectReference)mor)) instanceof HostSystem) {
                return ((HostSystem)mo).getName();
            }
            return null;
        }
    }
}

