/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.actions;

import com.vmware.vide.rse.model.VirtualMachineElement;
import com.vmware.vide.rse.util.RSEHelper;
import com.vmware.vide.utils.net.HttpLogger;
import com.vmware.vim25.VirtualMachinePowerState;
import com.vmware.vim25.VirtualMachineRuntimeInfo;
import com.vmware.vim25.mo.Task;
import java.util.Iterator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.swt.widgets.Shell;

public class VirtualMachineElementAction
extends SystemBaseAction {
    private VirtualMachineElement selected;
    private String actionId;

    public VirtualMachineElementAction(String text, String tooltip, ImageDescriptor image, Shell parent) {
        super(text, tooltip, image, parent);
        this.actionId = text;
        this.selected = null;
    }

    public boolean updateSelection(IStructuredSelection selection) {
        Object object;
        Iterator e = selection.iterator();
        if (e.hasNext() && (object = e.next()) instanceof VirtualMachineElement) {
            this.selected = (VirtualMachineElement)((Object)object);
            return true;
        }
        return false;
    }

    public void run() {
        VirtualMachineRuntimeInfo vmri = this.selected.getRuntime();
        VirtualMachinePowerState ps = vmri.getPowerState();
        if (ps == VirtualMachinePowerState.poweredOn) {
            if (this.actionId == "Power On") {
                MessageDialog.openError((Shell)this.getShell(), (String)"Invalide Action", (String)"Virutlal Machine is already powered on");
                return;
            }
        } else if (this.actionId == "Power Off" || this.actionId == "Reset" || this.actionId == "Suspend") {
            MessageDialog.openError((Shell)this.getShell(), (String)"Invalid Action", (String)"Virtual Machine is not powered on");
            return;
        }
        HttpLogger.logActivity((String)"rse", (String)"ESXVmAction", (String)this.actionId);
        PowerOperation power = new PowerOperation(this.actionId);
        power.schedule();
    }

    protected ISubSystem getSubSystem() {
        if (this.selected != null) {
            return this.selected.getSubSystem();
        }
        return null;
    }

    private class PowerOperation
    extends Job {
        PowerOperation(String name) {
            super(name);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                try {
                    Task pTask = VirtualMachineElementAction.this.selected.getTask(VirtualMachineElementAction.this.actionId);
                    RSEHelper.waitForTask(pTask);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    monitor.done();
                }
            }
            finally {
                monitor.done();
            }
            return Status.OK_STATUS;
        }
    }
}

