/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.views;

import com.vmware.vide.rse.ui.views.NullLogger;
import java.io.IOException;
import java.util.HashMap;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.sequoyah.vnc.protocol.PluginProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.IProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolActionDelegate;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolHandle;
import org.eclipse.sequoyah.vnc.protocol.lib.ProtocolMessage;
import org.eclipse.sequoyah.vnc.utilities.logger.ILogger;
import org.eclipse.sequoyah.vnc.utilities.logger.Logger;
import org.eclipse.sequoyah.vnc.vncviewer.VNCViewerPlugin;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.RemoteDisplayFactory;
import org.eclipse.sequoyah.vnc.vncviewer.graphics.swt.SWTRemoteDisplay;
import org.eclipse.sequoyah.vnc.vncviewer.network.VNCProtocolExceptionHandler;
import org.eclipse.sequoyah.vnc.vncviewer.vncviews.views.ProtocolIdTranslator;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;

public class VNCViewerView
extends ViewPart {
    private static final String VIEWER_COULD_NOT_BE_STARTED = "Viewer could not be started: ";
    private static final String SWTDISPLAY = "SWTDisplay";
    private SWTRemoteDisplay swtDisplay;
    private boolean running = false;
    public ProtocolHandle protocolHandle;
    private int zoomFactor = 1;
    private static String[] currentConnection = new String[]{"", ""};
    private String currentHost;
    private String currentPort;

    public void createPartControl(Composite parent) {
        Logger.setLogger((ILogger)new NullLogger());
        final ScrolledComposite scomposite = new ScrolledComposite(parent, 2816);
        this.swtDisplay = (SWTRemoteDisplay)RemoteDisplayFactory.getDisplay((String)SWTDISPLAY, (Composite)scomposite);
        this.running = true;
        scomposite.setContent((Control)this.swtDisplay);
        scomposite.setExpandHorizontal(true);
        scomposite.setExpandVertical(true);
        this.swtDisplay.getCanvas().addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                Point size = VNCViewerView.this.swtDisplay.getCanvas().getSize();
                scomposite.setMinSize(VNCViewerView.this.swtDisplay.getParent().computeSize(size.x, size.y));
            }
        });
        this.swtDisplay.getCanvas().setSize(0, 0);
        if (this.protocolHandle != null) {
            try {
                this.swtDisplay.start(this.protocolHandle);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setFocus() {
        if (this.swtDisplay != null) {
            this.swtDisplay.setFocus();
        }
    }

    public void dispose() {
        try {
            this.stopProtocol();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.running = false;
        if (this.swtDisplay != null) {
            this.swtDisplay.dispose();
        }
        super.dispose();
    }

    public void start(String host, int port, String protoVersion, String password, boolean bypassProxy, IProgressMonitor monitor) throws Exception {
        if (this.running && this.swtDisplay != null) {
            if (this.swtDisplay.isActive()) {
                this.swtDisplay.stop();
            }
            try {
                HashMap<String, Object> parameters = new HashMap<String, Object>();
                String protocolId = ProtocolIdTranslator.getProtocolId((String)protoVersion);
                parameters.put("password", password);
                parameters.put("connectionRetries", this.swtDisplay.getConnectionRetries());
                parameters.put("bypassProxy", new Boolean(bypassProxy));
                this.protocolHandle = PluginProtocolActionDelegate.requestStartProtocolAsClient((String)protocolId, (IProtocolExceptionHandler)new VNCProtocolExceptionHandler(), (String)host, (int)port, parameters);
                while (!PluginProtocolActionDelegate.isProtocolRunning((ProtocolHandle)this.protocolHandle)) {
                    Thread.sleep(500L);
                    if (!monitor.isCanceled()) continue;
                    throw new OperationCanceledException();
                }
                this.swtDisplay.start(this.protocolHandle);
                this.currentHost = host;
                this.currentPort = Integer.toString(port);
            }
            catch (Exception e) {
                Canvas canvas;
                VNCViewerPlugin.log(VNCViewerView.class).error((Object)(VIEWER_COULD_NOT_BE_STARTED + e.getMessage()));
                this.stopProtocol();
                this.protocolHandle = null;
                if (!this.swtDisplay.isDisposed() && (canvas = this.swtDisplay.getCanvas()) != null && !canvas.isDisposed()) {
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            GC gc = new GC((Drawable)VNCViewerView.this.swtDisplay.getCanvas());
                            gc.fillRectangle(0, 0, VNCViewerView.this.swtDisplay.getScreenWidth(), VNCViewerView.this.swtDisplay.getScreenHeight());
                            gc.dispose();
                        }
                    });
                }
                throw e;
            }
        }
    }

    public void stop() {
        if (this.running && this.swtDisplay != null && this.swtDisplay.isActive()) {
            this.swtDisplay.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    VNCViewerView.this.swtDisplay.stop();
                    VNCViewerView.this.zoomFactor = 1;
                    VNCViewerView.this.swtDisplay.setZoomFactor((double)VNCViewerView.this.zoomFactor);
                    VNCViewerView.this.swtDisplay.getCanvas().setSize(0, 0);
                }
            });
        }
    }

    public void zoomIn() {
        double newzoom = 1.0;
        if (!this.swtDisplay.isActive()) {
            return;
        }
        this.zoomFactor = this.zoomFactor == -2 ? 1 : ++this.zoomFactor;
        newzoom = this.zoomFactor >= 1 ? (double)this.zoomFactor : 1.0 / (double)(-this.zoomFactor);
        this.swtDisplay.setZoomFactor(newzoom);
        try {
            this.swtDisplay.updateRequest(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void zoomOut() {
        double newzoom = 1.0;
        if (!this.swtDisplay.isActive()) {
            return;
        }
        this.zoomFactor = this.zoomFactor == 1 ? -2 : --this.zoomFactor;
        newzoom = this.zoomFactor >= 1 ? (double)this.zoomFactor : 1.0 / (double)(-this.zoomFactor);
        this.swtDisplay.setZoomFactor(newzoom);
        try {
            this.swtDisplay.updateRequest(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCrtlAltDel() {
        if (this.protocolHandle != null) {
            ProtocolMessage message = new ProtocolMessage(4L);
            message.setFieldValue("downFlag", (Object)1);
            message.setFieldValue("key", (Object)65507);
            ProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.protocolHandle, (ProtocolMessage)message);
            message = new ProtocolMessage(4L);
            message.setFieldValue("downFlag", (Object)1);
            message.setFieldValue("key", (Object)65513);
            ProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.protocolHandle, (ProtocolMessage)message);
            message = new ProtocolMessage(4L);
            message.setFieldValue("downFlag", (Object)1);
            message.setFieldValue("key", (Object)65535);
            ProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.protocolHandle, (ProtocolMessage)message);
            message = new ProtocolMessage(4L);
            message.setFieldValue("downFlag", (Object)0);
            message.setFieldValue("key", (Object)65507);
            ProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.protocolHandle, (ProtocolMessage)message);
            message = new ProtocolMessage(4L);
            message.setFieldValue("downFlag", (Object)0);
            message.setFieldValue("key", (Object)65513);
            ProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.protocolHandle, (ProtocolMessage)message);
            message = new ProtocolMessage(4L);
            message.setFieldValue("downFlag", (Object)0);
            message.setFieldValue("key", (Object)65535);
            ProtocolActionDelegate.sendMessageToServer((ProtocolHandle)this.protocolHandle, (ProtocolMessage)message);
        }
    }

    public void stopProtocol() throws IOException {
        if (this.protocolHandle != null) {
            PluginProtocolActionDelegate.requestStopProtocol((ProtocolHandle)this.protocolHandle);
        }
    }

    public SWTRemoteDisplay getSWTRemoteDisplay() {
        return this.swtDisplay;
    }

    public String getCurrentHost() {
        return this.currentHost;
    }

    public String getCurrentPort() {
        return this.currentPort;
    }

    public void setPartName(String name) {
        super.setPartName(name);
    }
}

