/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.ui.wizard.InstallWizard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.ui.wizards.newconnection.RSEDefaultNewConnectionWizard;
import org.eclipse.rse.ui.wizards.newconnection.RSEMainNewConnectionWizard;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.model.BaseWorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class InstallMainPage
extends WizardPage
implements Listener {
    private Text filetext;
    private Button fileBrowser;
    private Button projectBrowser;
    private List<IHost> hosts = new ArrayList<IHost>();

    protected InstallMainPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription("Select a file and targets to install");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        Group group = new Group(composite, 0);
        group.setLayout((Layout)new GridLayout(8, true));
        group.setLayoutData((Object)new GridData(1808));
        group.setText("Select a file to install");
        new Label((Composite)group, 16384).setText("File :");
        InstallWizard wizard = (InstallWizard)this.getWizard();
        this.filetext = new Text((Composite)group, 2048);
        GridData data = new GridData(768);
        data.horizontalSpan = 5;
        data.widthHint = 100;
        data.grabExcessHorizontalSpace = true;
        this.filetext.setLayoutData((Object)data);
        if (wizard.getInitFile() != null) {
            this.filetext.setText(wizard.getInitFile().getLocation().toOSString());
        }
        this.fileBrowser = new Button((Composite)group, 8);
        this.fileBrowser.setText("Browse...");
        this.fileBrowser.addListener(13, (Listener)this);
        this.projectBrowser = new Button((Composite)group, 8);
        this.projectBrowser.setText("Projects...");
        this.projectBrowser.addListener(13, (Listener)this);
        new Label(composite, 0);
        Group hgroup = new Group(composite, 0);
        hgroup.setLayout((Layout)new GridLayout());
        data = new GridData(4, 4, true, true);
        data.heightHint = 100;
        hgroup.setLayoutData((Object)data);
        hgroup.setText("Choose hosts to install package on");
        final ScrolledComposite scroll = new ScrolledComposite((Composite)hgroup, 512);
        scroll.setLayoutData((Object)new GridData(4, 4, true, true));
        final Composite child = new Composite((Composite)scroll, 0);
        child.setLayout((Layout)new GridLayout(2, true));
        IHost[] hostList = this.getHostList();
        int i = 0;
        while (i < hostList.length) {
            IHost host = hostList[i];
            Button button = this.createHostButton(child, host);
            if (host.equals(wizard.getInitHost())) {
                button.setSelection(true);
                this.hosts.add(host);
            }
            ++i;
        }
        child.setSize(group.computeSize((int)-1, (int)-1).x - 20, child.computeSize((int)-1, (int)-1).y);
        scroll.setContent((Control)child);
        Button addButton = new Button(composite, 0);
        data = new GridData();
        data.widthHint = 90;
        data.horizontalAlignment = 131072;
        addButton.setLayoutData((Object)data);
        addButton.setText("Add Target");
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IWizard realWizard;
                RSEMainNewConnectionWizard wizard = new RSEMainNewConnectionWizard();
                wizard.init(PlatformUI.getWorkbench(), (IStructuredSelection)new StructuredSelection());
                WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)wizard);
                dialog.create();
                if (dialog.open() == 0 && (realWizard = wizard.getSelectedWizard()) instanceof RSEDefaultNewConnectionWizard) {
                    IHost host = ((RSEDefaultNewConnectionWizard)realWizard).getCreatedHost();
                    InstallMainPage.this.createHostButton(child, host);
                    Rectangle rect = scroll.getClientArea();
                    child.setSize(rect.width, child.computeSize((int)-1, (int)-1).y);
                    child.layout();
                }
            }
        });
        this.setControl((Control)composite);
    }

    private Button createHostButton(Composite composite, final IHost host) {
        Button button = new Button(composite, 32);
        button.setLayoutData((Object)new GridData(768));
        button.setText(host.getAliasName());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                Button button = (Button)event.widget;
                if (button.getSelection()) {
                    InstallMainPage.this.hosts.add(host);
                } else {
                    InstallMainPage.this.hosts.remove(host);
                }
                InstallMainPage.this.getWizard().getContainer().updateButtons();
            }
        });
        return button;
    }

    public boolean canFlipToNextPage() {
        return !this.filetext.getText().trim().isEmpty() && this.hosts.size() > 0;
    }

    public void handleEvent(Event event) {
        if (event.widget == this.fileBrowser) {
            FileDialog dialog = new FileDialog(this.getShell());
            dialog.setText("Select a VIB or RPM package");
            String file = dialog.open();
            if (file != null && !file.isEmpty()) {
                this.filetext.setText(file);
            }
        } else if (event.widget == this.projectBrowser) {
            Object[] results;
            IFile file;
            String filePath;
            ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new BaseWorkbenchContentProvider());
            dialog.setTitle("Select a VIB or RPM package");
            dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    if (selection != null && selection.length > 0 && selection[0] instanceof IFile) {
                        return Status.OK_STATUS;
                    }
                    return new Status(4, "com.vmware.vide.rse", "Choose a file to install");
                }
            });
            if (dialog.open() == 0 && (filePath = (file = (IFile)(results = dialog.getResult())[0]).getLocation().toOSString()) != null && !filePath.isEmpty()) {
                this.filetext.setText(filePath);
            }
        }
        this.getWizard().getContainer().updateButtons();
    }

    public IHost[] getHosts() {
        return this.hosts.toArray(new IHost[this.hosts.size()]);
    }

    public String getPackageFile() {
        return this.filetext.getText().trim();
    }

    private IHost[] getHostList() {
        try {
            RSECorePlugin.waitForInitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        IHost[] hosts = registry.getHosts();
        ArrayList<IHost> results = new ArrayList<IHost>();
        int i = 0;
        while (i < hosts.length) {
            if (!hosts[i].equals(registry.getLocalHost())) {
                results.add(hosts[i]);
            }
            ++i;
        }
        return results.toArray(new IHost[results.size()]);
    }
}

