/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.ui.wizard.InstallProgressPage;
import com.vmware.vide.rse.ui.wizard.InstallWizard;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class InstallSummaryPage
extends WizardPage {
    List<IHost> rebootSelected = new ArrayList<IHost>();
    List<IHost> restartSelected = new ArrayList<IHost>();

    public InstallSummaryPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
        this.setDescription("Installation report for each host.");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        ArrayList<IHost> rebootRequired = new ArrayList<IHost>();
        ArrayList<IHost> restartRequired = new ArrayList<IHost>();
        InstallProgressPage.InstallReport[] reports = ((InstallWizard)this.getWizard()).getReports();
        if (reports.length > 0) {
            Group group = new Group(composite, 0);
            GridLayout layout = new GridLayout();
            layout.verticalSpacing = 10;
            group.setLayout((Layout)layout);
            group.setLayoutData((Object)new GridData(768));
            group.setText("Installation Summary");
            int i = 0;
            while (i < reports.length) {
                StringBuffer buffer = new StringBuffer(reports[i].getHost().getAliasName());
                buffer.append("\t: ");
                if (reports[i].isSuccessful()) {
                    buffer.append("Successfully installed on this machine. ");
                    if (reports[i].getRequirement() == 1) {
                        rebootRequired.add(reports[i].getHost());
                        buffer.append("Need to reboot target.");
                    } else if (reports[i].getRequirement() == 2) {
                        restartRequired.add(reports[i].getHost());
                        buffer.append("Need to restart host agent.");
                    }
                } else {
                    buffer.append("Failed to install on this machine.");
                }
                new Label((Composite)group, 0).setText(buffer.toString());
                ++i;
            }
        }
        if (rebootRequired.size() > 0) {
            this.createHostSelectionArea(composite, 1, rebootRequired);
        } else if (restartRequired.size() > 0) {
            this.createHostSelectionArea(composite, 2, restartRequired);
        }
        this.setControl((Control)composite);
    }

    public IHost[] getRebootSelectedHosts() {
        return this.rebootSelected.toArray(new IHost[this.rebootSelected.size()]);
    }

    public IHost[] getRestartSelectedHosts() {
        return this.restartSelected.toArray(new IHost[this.restartSelected.size()]);
    }

    private void createHostSelectionArea(Composite parent, final int mode, List<IHost> hlist) {
        new Label(parent, 0);
        Group group = new Group(parent, 0);
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        if (mode == 1) {
            group.setText("Please check box if you want to reboot");
        } else if (mode == 2) {
            group.setText("Please check box if you want to restart mamangement agent");
        }
        int i = 0;
        while (i < hlist.size()) {
            final IHost host = hlist.get(i);
            Button button = new Button((Composite)group, 32);
            button.setText(host.getAliasName());
            button.setLayoutData((Object)new GridData(768));
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    Button button = (Button)event.widget;
                    if (button.getSelection()) {
                        if (mode == 1) {
                            InstallSummaryPage.this.rebootSelected.add(host);
                        } else if (mode == 2) {
                            InstallSummaryPage.this.restartSelected.add(host);
                        }
                    } else if (mode == 1) {
                        InstallSummaryPage.this.rebootSelected.remove(host);
                    } else if (mode == 2) {
                        InstallSummaryPage.this.restartSelected.remove(host);
                    }
                }
            });
            ++i;
        }
    }
}

