/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.ui.wizard;

import com.vmware.vide.rse.api.impl.RemoteProcess;
import com.vmware.vide.rse.ui.dialogs.PackageManagerDialog;
import com.vmware.vide.rse.ui.wizard.PackageRemoveWizard;
import com.vmware.vide.rse.util.RSEHelper;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.SequenceInputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PackageRemoveUninstallPage
extends WizardPage {
    private Text displayText;
    private boolean jobComplete = false;
    private boolean needToReboot = false;

    protected PackageRemoveUninstallPage(String pageName) {
        super(pageName);
        this.setTitle("Uninstall Packages");
        this.setDescription("Uninstall VIB packages from the host");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.initializeDialogUnits((Control)composite);
        Composite header = new Composite(composite, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        header.setLayout((Layout)layout);
        header.setLayoutData((Object)new GridData(768));
        this.initializeDialogUnits((Control)header);
        final Label label = new Label(header, 0);
        label.setText("Click on \"Uninstall\" button to start uninstallation");
        label.setLayoutData((Object)new GridData(768));
        final Button button = new Button(header, 8);
        button.setText("&Uninstall");
        GridData data = new GridData(0x1000008, 0, false, false);
        data.widthHint = this.convertHorizontalDLUsToPixels(61);
        button.setLayoutData((Object)data);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                button.setEnabled(false);
                label.setEnabled(false);
                if (PackageRemoveUninstallPage.this.getWizard() instanceof PackageRemoveWizard) {
                    PackageRemoveWizard myWizard = (PackageRemoveWizard)PackageRemoveUninstallPage.this.getWizard();
                    List<PackageManagerDialog.VibPackage> packages = myWizard.getPackages();
                    String options = myWizard.getOptions();
                    IHost host = myWizard.getHost();
                    PackageRemoveUninstallPage.this.displayText.setText("");
                    try {
                        try {
                            RemoveJob remoteJob = new RemoveJob(host, packages, options);
                            PackageRemoveUninstallPage.this.getContainer().run(true, true, (IRunnableWithProgress)remoteJob);
                            PackageRemoveUninstallPage.this.needToReboot = PackageRemoveUninstallPage.this.displayText.getText().contains("needs to be rebooted");
                            if (PackageRemoveUninstallPage.this.canDisableUninstall(remoteJob)) {
                                label.setText("The uninstall operation has succeeded");
                            } else {
                                button.setEnabled(true);
                            }
                            label.setEnabled(true);
                        }
                        catch (InvocationTargetException e1) {
                            e1.printStackTrace();
                            PackageRemoveUninstallPage.this.jobComplete = true;
                            PackageRemoveUninstallPage.this.getWizard().getContainer().updateButtons();
                        }
                        catch (InterruptedException e1) {
                            e1.printStackTrace();
                            PackageRemoveUninstallPage.this.jobComplete = true;
                            PackageRemoveUninstallPage.this.getWizard().getContainer().updateButtons();
                        }
                    }
                    finally {
                        PackageRemoveUninstallPage.this.jobComplete = true;
                        PackageRemoveUninstallPage.this.getWizard().getContainer().updateButtons();
                    }
                }
            }
        });
        this.displayText = new Text(composite, 2634);
        data = new GridData(1808);
        this.displayText.setLayoutData((Object)data);
        this.setControl((Control)composite);
    }

    private boolean canDisableUninstall(RemoveJob remoteJob) {
        return remoteJob.getResults() == 0 && !remoteJob.getOptions().contains("dry-run");
    }

    public boolean isPageComplete() {
        return this.jobComplete;
    }

    public boolean rebootNeeded() {
        return this.jobComplete && this.needToReboot;
    }

    private class RemoveJob
    implements IRunnableWithProgress {
        static final int SUCCESS = 0;
        private final List<PackageManagerDialog.VibPackage> packages;
        private final String options;
        private final IHost host;
        private int results = -1;

        public RemoveJob(IHost host, List<PackageManagerDialog.VibPackage> packages, String options) {
            this.packages = packages;
            this.options = options;
            this.host = host;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
            block26: {
                monitor.beginTask("Uninstalling Packages", -1);
                BufferedReader reader = null;
                RemoteProcess proc = null;
                try {
                    try {
                        String line;
                        IRemoteFileSubSystem fss = RemoteFileUtility.getFileSubSystem((IHost)this.host);
                        if (!fss.isConnected()) {
                            fss.connect(monitor, false);
                        }
                        StringBuffer command = new StringBuffer("esxcli software vib remove");
                        command.append(this.options);
                        for (PackageManagerDialog.VibPackage pkg : this.packages) {
                            command.append(" --vibname ");
                            command.append("\"");
                            command.append(pkg.getFullName());
                            command.append("\"");
                        }
                        proc = new RemoteProcess(this.host, command.toString());
                        SequenceInputStream is = new SequenceInputStream(proc.getInputStream(), proc.getErrorStream());
                        reader = new BufferedReader(new InputStreamReader(is));
                        proc.run();
                        while ((line = reader.readLine()) != null) {
                            final String aLine = String.valueOf(line) + "\n";
                            Display.getDefault().asyncExec(new Runnable(){

                                @Override
                                public void run() {
                                    PackageRemoveUninstallPage.this.displayText.append(aLine);
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        final String error = RSEHelper.getErrorMessage(e);
                        Display.getDefault().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                PackageRemoveUninstallPage.this.setErrorMessage(error);
                            }
                        });
                        if (proc != null) {
                            try {
                                this.results = proc.exitValue();
                            }
                            catch (Exception e2) {
                                e2.printStackTrace();
                            }
                        }
                        if (reader != null) {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {}
                        }
                        monitor.done();
                        break block26;
                    }
                }
                catch (Throwable throwable) {
                    if (proc != null) {
                        try {
                            this.results = proc.exitValue();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    monitor.done();
                    throw throwable;
                }
                if (proc != null) {
                    try {
                        this.results = proc.exitValue();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                }
                monitor.done();
            }
        }

        int getResults() {
            return this.results;
        }

        String getOptions() {
            return this.options;
        }
    }
}

