/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.resources.SystemRemoteEditManager;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.view.ISystemEditableRemoteObject;

public class RSEFileUtils {
    private RSEFileUtils() {
    }

    public static String readFile(IHost host, String file) throws Exception {
        IRemoteFileSubSystem remoteHostFileSystem = RemoteFileUtility.getFileSubSystem((IHost)host);
        IRemoteFile remoteFile = remoteHostFileSystem.getRemoteFileObject(file, (IProgressMonitor)new NullProgressMonitor());
        SystemEditableRemoteFile editableRemoteFile = SystemRemoteEditManager.getEditableRemoteObject((Object)remoteFile, null);
        return RSEFileUtils.getRemoteFileContents(remoteFile, editableRemoteFile);
    }

    public static void writeFile(IHost host, String file, String content) throws SystemMessageException, IOException {
        IRemoteFileSubSystem remoteHostFileSystem = RemoteFileUtility.getFileSubSystem((IHost)host);
        IRemoteFile remoteFile = remoteHostFileSystem.getRemoteFileObject(file, (IProgressMonitor)new NullProgressMonitor());
        SystemEditableRemoteFile editableRemoteFile = SystemRemoteEditManager.getEditableRemoteObject((Object)remoteFile, null);
        String encoding = remoteFile.getEncoding();
        File tempFile = new File(editableRemoteFile.getLocalPath());
        FileUtils.writeStringToFile((File)tempFile, (String)content, (String)encoding);
        RSEFileUtils.uploadRemoteFile(remoteHostFileSystem, tempFile.getPath(), remoteFile, encoding, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isFileInCache(ISystemEditableRemoteObject editable, IRemoteFile remoteFile) throws Exception {
        boolean newFile;
        IFile file = editable.getLocalResource();
        SystemIFileProperties properties = new SystemIFileProperties((IResource)file);
        boolean bl = newFile = !file.exists();
        if (!newFile && file.exists()) {
            remoteFile.markStale(true);
            IRemoteFileSubSystem subsystem = remoteFile.getParentRemoteFileSubSystem();
            remoteFile = subsystem.getRemoteFileObject(remoteFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
            boolean dirty = properties.getDirty();
            boolean encodingChanged = RSEFileUtils.hasEncodingChanged(properties, remoteFile);
            boolean timestampChanged = RSEFileUtils.hasTimestampChanged(properties, remoteFile);
            boolean isReadOnly = RSEFileUtils.isReadOnly(properties, remoteFile);
            return !dirty && !encodingChanged && !timestampChanged && isReadOnly;
        }
        return false;
    }

    private static boolean hasEncodingChanged(SystemIFileProperties properties, IRemoteFile remoteFile) {
        String remoteEncoding = remoteFile.getEncoding();
        String storedEncoding = properties.getEncoding();
        return storedEncoding == null || !remoteEncoding.equals(storedEncoding);
    }

    private static boolean hasTimestampChanged(SystemIFileProperties properties, IRemoteFile remoteFile) {
        long remoteModifiedStamp;
        long storedModifiedStamp = properties.getRemoteFileTimeStamp();
        return storedModifiedStamp != (remoteModifiedStamp = remoteFile.getLastModified());
    }

    private static boolean isReadOnly(SystemIFileProperties properties, IRemoteFile remoteFile) {
        boolean usedReadOnly = properties.getReadOnly();
        boolean isReadOnly = !remoteFile.canWrite();
        return usedReadOnly == isReadOnly;
    }

    public static void uploadRemoteFile(IRemoteFileSubSystem fs, String path, IRemoteFile remoteFile, String encoding, IProgressMonitor monitor) throws SystemMessageException {
        fs.upload(path, remoteFile, encoding, null);
    }

    public static String getRemoteFileContents(IRemoteFile remoteFile, SystemEditableRemoteFile editableRemoteFile) throws Exception {
        String content = null;
        if (RSEFileUtils.isFileInCache((ISystemEditableRemoteObject)editableRemoteFile, remoteFile)) {
            IFile cachedFile = editableRemoteFile.getLocalResource();
            InputStream is = cachedFile.getContents();
            content = IOUtils.toString((InputStream)is);
        } else if (editableRemoteFile.download((IProgressMonitor)new NullProgressMonitor())) {
            File file = new File(editableRemoteFile.getLocalPath());
            content = FileUtils.readFileToString((File)file);
        }
        return content;
    }
}

