/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.util;

import com.vmware.vide.rse.connector.ResourcesConnectorService;
import com.vmware.vide.rse.connector.vIDESshConnectorServiceManager;
import com.vmware.vide.rse.subsystems.IResourcesSubSystem;
import com.vmware.vide.rse.subsystems.ResourcesSubSystem;
import com.vmware.vim25.AboutInfo;
import com.vmware.vim25.RuntimeFault;
import com.vmware.vim25.mo.ServiceInstance;
import com.vmware.vim25.mo.Task;
import java.rmi.RemoteException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertySet;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;

public class RSEHelper {
    public static IHost findHost(String hostName) {
        IHost[] hosts;
        ISystemRegistry registry = RSECorePlugin.getTheSystemRegistry();
        IHost[] iHostArray = hosts = registry.getHosts();
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            IHost host = iHostArray[n2];
            if (host.getHostName().equalsIgnoreCase(hostName)) {
                return host;
            }
            ++n2;
        }
        return null;
    }

    public static boolean isVisor(IHost host) throws Exception {
        String value;
        PropertySet set;
        ResourcesSubSystem rss = RSEHelper.getResourcesSubSystem(host);
        if (rss == null) {
            return false;
        }
        if (!rss.isConnected()) {
            rss.connect((IProgressMonitor)new NullProgressMonitor(), false);
        }
        if ((set = (PropertySet)host.getPropertySet("ESX Properties")) != null && !set.isDirty() && (value = set.getPropertyValue("visor")) != null) {
            return Boolean.parseBoolean(value);
        }
        ServiceInstance si = ((ResourcesConnectorService)rss.getConnectorService()).getServiceInstance();
        if (si == null) {
            throw new Exception("No ServiceInstance for " + host);
        }
        AboutInfo info = si.getAboutInfo();
        boolean isVisor = info.getName().toLowerCase().contains("esxi") || info.getName().toLowerCase().contains("3i");
        if (set == null) {
            set = new PropertySet("ESX Properties");
            set.addProperty("visor", isVisor ? "true" : "false");
            host.addPropertySet((IPropertySet)set);
        } else {
            set.addProperty("visor", isVisor ? "true" : "false");
        }
        host.commit();
        return isVisor;
    }

    public static boolean isESX50(IHost host) throws Exception {
        String[] tokens = RSEHelper.getESXVersion(host).split("\\.");
        return "5".equals(tokens[0]);
    }

    public static boolean isESX50OrHigher(IHost host) throws Exception {
        String[] tokens = RSEHelper.getESXVersion(host).split("\\.");
        return Integer.parseInt(tokens[0]) >= 5;
    }

    private static String getESXVersion(IHost host) throws Exception {
        ServiceInstance si = RSEHelper.getServiceInstance(host);
        if (si == null) {
            throw new Exception("Failed to get Service Instance");
        }
        AboutInfo info = si.getAboutInfo();
        String version = info.getVersion();
        return version;
    }

    public static ServiceInstance getServiceInstance(IHost host) throws Exception {
        IConnectorService[] connectors;
        IConnectorService[] iConnectorServiceArray = connectors = host.getConnectorServices();
        int n = connectors.length;
        int n2 = 0;
        while (n2 < n) {
            IConnectorService connector = iConnectorServiceArray[n2];
            if (connector instanceof ResourcesConnectorService) {
                if (!connector.isConnected()) {
                    if (!vIDESshConnectorServiceManager.getInstance().getSuppressPopups()) {
                        connector.acquireCredentials(false);
                    } else if (!connector.hasPassword(true)) {
                        throw new Exception("No password.");
                    }
                    connector.connect((IProgressMonitor)new NullProgressMonitor());
                }
                return ((ResourcesConnectorService)connector).getServiceInstance();
            }
            ++n2;
        }
        return null;
    }

    public static ResourcesSubSystem getResourcesSubSystem(IHost host) {
        if (host != null) {
            ISubSystem[] sses;
            ISubSystem[] iSubSystemArray = sses = host.getSubSystems();
            int n = sses.length;
            int n2 = 0;
            while (n2 < n) {
                ISubSystem ss = iSubSystemArray[n2];
                if (ss instanceof IResourcesSubSystem) {
                    return (ResourcesSubSystem)ss;
                }
                ++n2;
            }
        }
        return null;
    }

    public static String getErrorMessage(Exception exp) {
        SystemMessageException sys;
        String error = null;
        if (exp instanceof SystemMessageException && (error = (sys = (SystemMessageException)((Object)exp)).getSystemMessage().getLevelTwoText()) == null) {
            error = sys.getSystemMessage().getLevelOneText();
        }
        if (error == null && (error = exp.getLocalizedMessage()) == null) {
            error = exp.getClass().getName();
        }
        return error;
    }

    public static String waitForTask(Task task) throws RuntimeFault, RemoteException, InterruptedException {
        return task.waitForTask();
    }
}

