/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vide.rse.util;

import com.vmware.vide.rse.exception.HostNotFoundException;
import com.vmware.vide.target.api.ITarget;
import com.vmware.vide.target.api.TargetManagerPlugin;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.PasswordPersistenceManager;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.SystemSignonInformation;

public class RSEUtils {
    private RSEUtils() {
    }

    public static IHost getHostByName(String hostName) throws HostNotFoundException {
        IHost[] hosts;
        IHost[] iHostArray = hosts = RSECorePlugin.getTheSystemRegistry().getHosts();
        int n = hosts.length;
        int n2 = 0;
        while (n2 < n) {
            IHost host = iHostArray[n2];
            if (host.getHostName().equals(hostName)) {
                return host;
            }
            ++n2;
        }
        throw new HostNotFoundException("Could not find vCenter Orchestrator host : " + hostName);
    }

    public static ITarget getTargetFromHost(IHost host) {
        ITarget[] targets;
        ITarget[] iTargetArray = targets = TargetManagerPlugin.getTheTargetManager().getTargets();
        int n = targets.length;
        int n2 = 0;
        while (n2 < n) {
            ITarget target = iTargetArray[n2];
            String hostName = host.getHostName();
            if (target.getHostName().equalsIgnoreCase(hostName)) {
                return target;
            }
            ++n2;
        }
        return null;
    }

    public static void persistPassword(String hostName, String username, String password, String systemType) {
        IRSESystemType type = RSEUtils.getSystemType(systemType);
        SystemSignonInformation ssi = new SystemSignonInformation(hostName, username, password, type);
        PasswordPersistenceManager.getInstance().add(ssi, true);
    }

    public static Map<String, String> getCredentials(String hostName, String username, String systemType) {
        HashMap<String, String> credentials = new HashMap<String, String>();
        IRSESystemType type = RSEUtils.getSystemType(systemType);
        PasswordPersistenceManager manager = PasswordPersistenceManager.getInstance();
        SystemSignonInformation ssi = manager.find(type, hostName, username);
        if (ssi != null) {
            credentials.put(ssi.getUserId(), ssi.getPassword());
        }
        return credentials;
    }

    public static IRSESystemType getSystemType(String systemType) {
        IRSESystemType type = RSECorePlugin.getTheCoreRegistry().getSystemTypeById(systemType);
        return type;
    }
}

