﻿/*
 * Copyright 2015, 2016 VMware, Inc.  All rights reserved.
 */

namespace vmware.samples.common
{
    using vmware.cis;

    /// <summary>
    /// vAPI connection utility class.
    /// </summary>
    public class VapiConnection : ServiceEndpoint<Session>
    {
        public VapiConnection(string url) :
            base(url)
        {
        }

        protected override char[] Login(Session session)
        {
            return session.Create();
        }

        protected override void Logout(Session session)
        {
            session.Delete();
        }
    }
}
