﻿
/*
 * Copyright 2016 VMware, Inc.  All rights reserved.
 */
namespace vmware.samples.vcenter.helpers
{
    using System;
    using System.Collections.Generic;
    using vmware.vcenter;
    using vmware.vapi.bindings;
    using vmware.samples.common;

    public class FolderHelper
    {
        /// <summary>
        /// Returns the identifier of a folder.
        ///
        /// Note: The method assumes that there is only one folder and
        ///  datacenter with the specified names.
        /// </summary>
        /// <param name="serviceManager">Helper for instantiating vapi services</param>
        /// <param name="datacenterName">name of the datacenter</param>
        /// <param name="folderName">name of the folder</param>
        /// <returns>identifier of a folder</returns>
        public static String GetFolder(
            ManagementNode serviceManager, String datacenterName,
            String folderName)
        {
            HashSet<string> datacenters = new HashSet<string>
            {
                DatacenterHelper.GetDatacenter(serviceManager, datacenterName)
            };
            FolderTypes.FilterSpec folderFilterSpec =
                new FolderTypes.FilterSpec();
            folderFilterSpec.SetNames(new HashSet<String> { folderName });
            folderFilterSpec.SetDatacenters(datacenters);

            Folder folderService =
                serviceManager.VapiConnection.GetService<Folder>();
            List<FolderTypes.Summary> folderSummaries =
                folderService.List(folderFilterSpec);

            if (folderSummaries.Count > 1)
            {
                throw new Exception(String.Format("More than one folder" +
                    " with the specified name {0} exist", folderName));
            }

            if (folderSummaries.Count <= 0)
            {
                throw new Exception(String.Format("Folder with name {0}" +
                                    "not found !", folderName));
            }

            return folderSummaries[0].GetFolder();
        }
    }
}
