﻿/*
 * Copyright 2016 VMware, Inc.  All rights reserved.
 */
namespace vmware.samples.vcenter.helpers
{
    using System;
    using System.Collections.Generic;
    using vmware.vcenter;
    using vmware.vapi.bindings;
    using vmware.samples.common;

    public class VmHelper
    {
        /// <summary>
        /// Returns the identifier of a VM
        ///
        /// Note: The method assumes that there is only one VM and datacenter
        ///  with the specified names.
        /// </summary>
        /// <param name="serviceManager">Helper for instantiating vapi services</param>
        /// <param name="datacenterName">name of the datacenter</param>
        /// <param name="vmName">name of the vm</param>
        /// <returns>the identifier of a VM</returns>
        public static String GetVm(
            ManagementNode serviceManager, String datacenterName,
            String vmName)
        {
            HashSet<string> datacenters = new HashSet<string>
            {
                DatacenterHelper.GetDatacenter(serviceManager, datacenterName)
            };
            VMTypes.FilterSpec vmFilterSpec = new VMTypes.FilterSpec();
            vmFilterSpec.SetNames(new HashSet<String> { vmName });
            vmFilterSpec.SetDatacenters(datacenters);

            VM vmService = serviceManager.VapiConnection.GetService<VM>();
            List<VMTypes.Summary> vmSummaries = vmService.List(vmFilterSpec);

            if (vmSummaries.Count > 1)
            {
                throw new Exception(String.Format("More than one vm" +
                    " with the specified name {0} exist",
                    vmName));

            }

            if (vmSummaries.Count <= 0)
            {
                throw new Exception(String.Format("VM with name {0}" +
                    "not found !", vmName));
            }

            return vmSummaries[0].GetVm();
        }
    }
}
