/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.saml;

import com.vmware.vapi.saml.XmlParserFactory;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureXmlParserFactory
implements XmlParserFactory {
    private final Logger log = LoggerFactory.getLogger(SecureXmlParserFactory.class);

    @Override
    public DocumentBuilder newDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setValidating(false);
        this.trySetFeature(dbf, "http://xml.org/sax/features/validation", false);
        this.trySetFeature(dbf, "http://javax.xml.XMLConstants/feature/secure-processing", true);
        this.trySetFeature(dbf, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
        this.trySetFeature(dbf, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
        this.trySetFeature(dbf, "http://apache.org/xml/features/disallow-doctype-decl", true);
        return dbf.newDocumentBuilder();
    }

    private void trySetFeature(DocumentBuilderFactory dbf, String featureKey, boolean value) {
        block2: {
            try {
                dbf.setFeature(featureKey, value);
            }
            catch (ParserConfigurationException e) {
                if (!this.log.isDebugEnabled()) break block2;
                this.log.debug("Couldn't apply feature " + featureKey + " to DocumentBuilderFactory " + dbf.getClass().getName() + " Can be safely ignored.");
            }
        }
    }
}

