/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.cis.authn.json;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.dsig.json.SignatureException;
import com.vmware.vapi.dsig.json.StsTrustChain;
import com.vmware.vapi.internal.cis.authn.json.JsonSignerImpl;
import com.vmware.vapi.internal.dsig.json.Canonicalizer;
import com.vmware.vapi.internal.dsig.json.JsonCanonicalizer;
import com.vmware.vapi.internal.dsig.json.Verifier;
import com.vmware.vapi.internal.security.SecurityUtil;
import com.vmware.vapi.internal.util.DateTimeConverter;
import com.vmware.vapi.protocol.RequestProcessor;
import com.vmware.vapi.saml.ConfirmationType;
import com.vmware.vapi.saml.DefaultTokenFactory;
import com.vmware.vapi.saml.SamlToken;
import com.vmware.vapi.saml.exception.InvalidTokenException;
import java.io.UnsupportedEncodingException;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JsonSignatureVerificationProcessor
implements RequestProcessor {
    private static final int MILLIS_PER_SECOND = 1000;
    private static final Message VERIFY_ERROR = MessageFactory.getMessage((String)"vapi.signature.verify", (String[])new String[0]);
    private static final Message DECODE_ERROR = MessageFactory.getMessage((String)"vapi.sso.signproc.decoderequest", (String[])new String[0]);
    private static final Logger logger = LoggerFactory.getLogger(JsonSignatureVerificationProcessor.class);
    private final DateTimeConverter dateConverter = new DateTimeConverter();
    private final Verifier jsonVerifier;
    private final DefaultTokenFactory tokenFactory = new DefaultTokenFactory();
    private final StsTrustChain stsTrustChain;
    private final long clockToleranceSec;

    public JsonSignatureVerificationProcessor(StsTrustChain stsTrustChain) {
        this(stsTrustChain, 600L);
    }

    public JsonSignatureVerificationProcessor(StsTrustChain stsTrustChain, long clockToleranceSec) {
        this(new JsonSignerImpl((Canonicalizer)new JsonCanonicalizer(), stsTrustChain), stsTrustChain, clockToleranceSec);
    }

    JsonSignatureVerificationProcessor(Verifier verifier, StsTrustChain stsTrustChain, long clockToleranceSec) {
        Validate.notNull((Object)verifier);
        Validate.notNull((Object)stsTrustChain);
        Validate.isTrue((clockToleranceSec > -1L ? 1 : 0) != 0);
        this.stsTrustChain = stsTrustChain;
        this.clockToleranceSec = clockToleranceSec;
        this.jsonVerifier = verifier;
    }

    public byte[] process(byte[] request, Map<String, Object> metadata, RequestProcessor.Request vapiRequest) {
        Validate.notNull((Object)request);
        Validate.notNull(metadata);
        Validate.notNull((Object)vapiRequest);
        ExecutionContext.SecurityContext ctx = this.getSecurityContext(vapiRequest);
        if (ctx == null) {
            return request;
        }
        String schemeId = (String)SecurityUtil.narrowType((Object)ctx.getProperty("authn_scheme_id"), String.class);
        if (!this.validateSchemeId(schemeId)) {
            return request;
        }
        String requestString = this.requestToString(request);
        SamlToken token = null;
        Exception error = null;
        try {
            token = schemeId.equalsIgnoreCase("com.vmware.vapi.std.security.saml_hok_token") ? this.validateSignature(ctx, requestString) : this.parseBearerToken(ctx);
        }
        catch (Exception e) {
            error = e;
        }
        Map<String, Object> addSecProcData = this.getSecurityProcData(metadata);
        addSecProcData.put("saml_token", token);
        addSecProcData.put("saml_error", error);
        metadata.put("security_processor_metadata", addSecProcData);
        return request;
    }

    private SamlToken validateSignature(ExecutionContext.SecurityContext ctx, String request) throws InvalidTokenException {
        assert (ctx != null);
        Map signature = (Map)SecurityUtil.narrowType((Object)ctx.getProperty("signature"), Map.class);
        if (signature == null) {
            logger.debug("Signature not found.");
            throw new SignatureException(VERIFY_ERROR);
        }
        this.validateSignatureTimestamp(ctx);
        signature.put("signatureAlgorithm", SecurityUtil.narrowType((Object)ctx.getProperty("signatureAlgorithm"), String.class));
        if (!this.jsonVerifier.verifySignature(request, signature, this.clockToleranceSec)) {
            throw new SignatureException(VERIFY_ERROR);
        }
        logger.debug("Signature validated");
        return this.parseToken(signature.get("samlToken"));
    }

    private void validateSignatureTimestamp(ExecutionContext.SecurityContext ctx) {
        Map timestamp = (Map)SecurityUtil.narrowType((Object)ctx.getProperty("timestamp"), Map.class);
        if (timestamp == null) {
            logger.debug("Timestamp is missing");
            throw new SignatureException(VERIFY_ERROR);
        }
        String createdStr = (String)timestamp.get("created");
        String expiresStr = (String)timestamp.get("expires");
        if (createdStr == null || expiresStr == null) {
            logger.debug("Invalid timestamp: " + createdStr + " " + expiresStr);
            throw new SignatureException(VERIFY_ERROR);
        }
        Calendar created = null;
        Calendar expires = null;
        try {
            created = this.dateConverter.fromStringValue(createdStr);
            expires = this.dateConverter.fromStringValue(expiresStr);
        }
        catch (ConstraintValidationException e) {
            logger.debug("Cannot convert timestamp date", (Throwable)e);
            throw new SignatureException(VERIFY_ERROR, (Throwable)e);
        }
        long createdMillis = created.getTimeInMillis();
        long expiresMillis = expires.getTimeInMillis();
        long toleranceMillis = this.clockToleranceSec * 1000L;
        if (createdMillis > expiresMillis) {
            logger.debug("Invalid timestamp: " + createdStr + " " + expiresStr);
            throw new SignatureException(VERIFY_ERROR);
        }
        long currentTime = System.currentTimeMillis();
        if (createdMillis > currentTime + toleranceMillis) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalid timestamp. Created: " + new Date(createdMillis) + " Current time: " + new Date(currentTime));
            }
            throw new SignatureException(VERIFY_ERROR);
        }
        if (expiresMillis < currentTime - toleranceMillis) {
            if (logger.isDebugEnabled()) {
                logger.debug("Invalid timestamp. Expires: " + new Date(expiresMillis) + " Current time: " + new Date(currentTime));
            }
            throw new SignatureException(VERIFY_ERROR);
        }
        logger.debug("Signature timestamp validated");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SamlToken parseToken(Object tokenString) throws InvalidTokenException {
        SamlToken token = null;
        if (tokenString instanceof String) {
            DefaultTokenFactory defaultTokenFactory = this.tokenFactory;
            synchronized (defaultTokenFactory) {
                token = this.tokenFactory.parseToken((String)tokenString, this.stsTrustChain.getStsTrustChain(), this.clockToleranceSec);
            }
        }
        return token;
    }

    private SamlToken parseBearerToken(ExecutionContext.SecurityContext ctx) throws InvalidTokenException {
        assert (ctx != null);
        SamlToken token = this.parseToken(ctx.getProperty("samlToken"));
        if (token == null || token.getConfirmationType() != ConfirmationType.BEARER) {
            throw new RuntimeException("Cannot parse bearer token: " + token);
        }
        return token;
    }

    private boolean validateSchemeId(String schemeId) {
        return schemeId != null && (schemeId.equalsIgnoreCase("com.vmware.vapi.std.security.saml_hok_token") || schemeId.equalsIgnoreCase("com.vmware.vapi.std.security.saml_bearer_token"));
    }

    private ExecutionContext.SecurityContext getSecurityContext(RequestProcessor.Request request) {
        ExecutionContext ctx = request.getCtx();
        if (ctx == null) {
            return null;
        }
        return ctx.retrieveSecurityContext();
    }

    private String requestToString(byte[] request) {
        try {
            return new String(request, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new CoreException(DECODE_ERROR);
        }
    }

    private Map<String, Object> getSecurityProcData(Map<String, Object> metadata) {
        assert (metadata != null);
        HashMap procDataStruct = (HashMap)SecurityUtil.narrowType((Object)metadata.get("security_processor_metadata"), Map.class);
        if (procDataStruct == null) {
            procDataStruct = new HashMap();
        }
        return procDataStruct;
    }
}

