/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.bindings;

import com.vmware.vapi.l10n.MessageArgConverter;
import com.vmware.vapi.l10n.TemplateFormatter;
import com.vmware.vapi.std.LocalizableMessage;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.lang.Validate;

public class LocalizableMessageFactory {
    private ResourceBundle msgBundle;
    private TemplateFormatter formatter;
    private MessageArgConverter msgArgConverter;

    public LocalizableMessageFactory(ResourceBundle msgBundle, TemplateFormatter formatter) {
        Validate.notNull((Object)msgBundle);
        this.msgBundle = msgBundle;
        this.formatter = formatter;
        this.msgArgConverter = new MessageArgConverter();
    }

    public LocalizableMessage getLocalizableMessage(String msgId, String ... args) {
        Validate.notNull((Object)msgId);
        try {
            String msgTemplate = this.msgBundle.getString(msgId);
            List<String> argsList = Arrays.asList(args);
            String defaultMessage = this.buildDefaultMessage(msgTemplate, argsList, this.msgBundle.getLocale());
            return new LocalizableMessage(msgId, defaultMessage, argsList);
        }
        catch (MissingResourceException ex) {
            return this.buildUnavailableMessage(msgId, args);
        }
        catch (ClassCastException ex) {
            return this.buildUnavailableMessage(msgId, args);
        }
    }

    public LocalizableMessage getLocalizableMessage(String msgId, Object ... args) {
        return this.getLocalizableMessage(msgId, this.msgArgConverter.convertToStrings(args));
    }

    LocalizableMessage buildUnavailableMessage(String msgId, String ... args) {
        String msgTemplate = "Unknown message ID %s requested with parameters %s";
        return new LocalizableMessage("vapi.message.unknown", String.format(msgTemplate, msgId, Arrays.toString(args)), Collections.emptyList());
    }

    String buildDefaultMessage(String msgTemplate, List<String> argsList, Locale locale) {
        if (this.formatter == null) {
            return msgTemplate;
        }
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        return this.formatter.format(msgTemplate, argsList, locale);
    }
}

