/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.config;

import com.vmware.vapi.config.Configurator;
import com.vmware.vapi.core.ApiProvider;
import com.vmware.vapi.internal.ClassLoaderUtil;
import com.vmware.vapi.internal.protocol.ProtocolHandlerFactoryImpl;
import com.vmware.vapi.protocol.ProtocolHandler;
import com.vmware.vapi.protocol.ProtocolHandlerFactory;
import com.vmware.vapi.provider.ApiInterface;
import com.vmware.vapi.provider.local.LocalProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PropertyConfigurator
implements Configurator {
    private final Properties props;
    private final ProtocolHandlerFactory handlerFactory;
    private final ApiProvider provider;
    private final List<ProtocolHandler> handlers;
    static final Logger logger = LoggerFactory.getLogger(PropertyConfigurator.class);

    public PropertyConfigurator(Properties props) {
        this(props, new ProtocolHandlerFactoryImpl());
    }

    public PropertyConfigurator(Properties props, ProtocolHandlerFactory handlerFactory) {
        Validate.notNull((Object)props);
        Validate.notNull((Object)handlerFactory);
        this.props = props;
        this.handlerFactory = handlerFactory;
        this.provider = this.createApiProvider("");
        this.handlers = this.createProtocolHandlers("", "protocols", this.provider);
    }

    @Override
    public ApiProvider getApiProvider() {
        return this.provider;
    }

    @Override
    public List<ProtocolHandler> getProtocolHandlers() {
        return this.handlers;
    }

    private ApiProvider createApiProvider(String propPrefix) {
        String providerName = this.getProperty(propPrefix, "provider.name");
        Class<? extends ApiProvider> providerClass = this.getProviderClass(propPrefix);
        if (LocalProvider.class == providerClass) {
            return this.createLocalProvider(providerName, propPrefix);
        }
        throw new IllegalArgumentException("Unsupported provider type: " + providerClass.getCanonicalName());
    }

    private Class<? extends ApiProvider> getProviderClass(String propPrefix) {
        Class<?> clazz;
        String providerClassName = this.getRequiredProperty(propPrefix, "provider.type");
        try {
            clazz = Class.forName(providerClassName);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not load provider class " + providerClassName, ex);
        }
        if (!ApiProvider.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("Provider class " + providerClassName + " does not implement ApiProvider interface ");
        }
        Class<?> providerClass = clazz;
        return providerClass;
    }

    private LocalProvider createLocalProvider(String name, String propPrefix) {
        List<ApiInterface> ifaces = this.createApiInterfaces(propPrefix, "local.interfaces");
        return new LocalProvider(name, ifaces);
    }

    private List<ApiInterface> createApiInterfaces(String propPrefix, String listPropName) {
        String[] names;
        ArrayList<ApiInterface> ifaces = new ArrayList<ApiInterface>();
        String namesList = this.getProperty(propPrefix, listPropName);
        if (namesList == null) {
            return ifaces;
        }
        for (String className : names = namesList.split(",")) {
            ApiInterface i = PropertyConfigurator.loadInterfaceByClass(className);
            ifaces.add(i);
        }
        return ifaces;
    }

    private static ApiInterface loadInterfaceByClass(String className) {
        className = className.trim();
        try {
            ClassLoader cl = ClassLoaderUtil.getServiceClassLoader();
            Class<?> clazz = cl.loadClass(className);
            Class<ApiInterface> ifaceClass = clazz.asSubclass(ApiInterface.class);
            ApiInterface ifaceInstance = ifaceClass.newInstance();
            return ifaceInstance;
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to load service of class " + className, e);
        }
    }

    private List<ProtocolHandler> createProtocolHandlers(String propPrefix, String listPropName, ApiProvider provider) {
        String[] protocolNames;
        ArrayList<ProtocolHandler> handlers = new ArrayList<ProtocolHandler>();
        String protocols = this.getProperty(propPrefix, listPropName);
        if (protocols == null || "".equals(protocols.trim())) {
            return handlers;
        }
        for (String p : protocolNames = protocols.split(",")) {
            String prefix = PropertyConfigurator.getPropertyName(propPrefix, "protocol." + p);
            ProtocolHandler handler = this.createProtocolHandler(prefix, provider);
            handlers.add(handler);
        }
        return handlers;
    }

    private ProtocolHandler createProtocolHandler(String propPrefix, ApiProvider provider) {
        String rpcProtocol = this.getRequiredProperty(propPrefix, "rpc");
        String args = this.getProperty(propPrefix, "rpc." + rpcProtocol + ".args");
        String ssl = this.getProperty(propPrefix, "ssl");
        ProtocolHandler curr = null;
        if (ssl != null && ssl.equalsIgnoreCase("true")) {
            String secureArgs = this.getProperty(propPrefix, "rpc." + rpcProtocol + ".secureargs");
            String keystore = this.getProperty(propPrefix, "ssl.keystore");
            String keystorePassword = this.getProperty(propPrefix, "ssl.password");
            String keyPassword = this.getProperty(propPrefix, "ssl.keypassword");
            String clientAuth = this.getProperty(propPrefix, "ssl.client.auth", "false");
            String truststore = this.getProperty(propPrefix, "ssl.client.keystore");
            String truststorePassword = this.getProperty(propPrefix, "ssl.client.password");
            ProtocolHandlerFactory.KeyStoreConfig ksConfig = new ProtocolHandlerFactory.KeyStoreConfig(keystore, keystorePassword, keyPassword);
            ProtocolHandlerFactory.TrustStoreConfig tsConfig = new ProtocolHandlerFactory.TrustStoreConfig(truststore, truststorePassword);
            curr = this.handlerFactory.getProtocolHandler(rpcProtocol, args, secureArgs, clientAuth, ksConfig, tsConfig, provider);
        } else if (ssl == null || ssl.equalsIgnoreCase("false")) {
            curr = this.handlerFactory.getInsecureProtocolHandler(rpcProtocol, args, provider);
        } else {
            throw new IllegalArgumentException("SSL property '" + PropertyConfigurator.getPropertyName(propPrefix, "ssl") + "' has invalid value '" + ssl + "'");
        }
        return curr;
    }

    static String getPropertyName(String prefix, String name) {
        if (prefix != null && !prefix.isEmpty()) {
            return prefix + "." + name;
        }
        return name;
    }

    private String getRequiredProperty(String propPrefix, String propName) {
        String name = PropertyConfigurator.getPropertyName(propPrefix, propName);
        String value = this.props.getProperty(name, null);
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("Missing property " + name);
        }
        return value;
    }

    private String getProperty(String propPrefix, String propName) {
        return this.getProperty(propPrefix, propName, null);
    }

    private String getProperty(String propPrefix, String propName, String defaultValue) {
        return this.props.getProperty(PropertyConfigurator.getPropertyName(propPrefix, propName), defaultValue);
    }
}

