/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DefinitionVisitor;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;

public class DynamicStructDefinition
extends DataDefinition {
    private static final DynamicStructDefinition INSTANCE = new DynamicStructDefinition();
    private static final EnumSet<DataType> VALID_DATA_TYPES = EnumSet.of(DataType.STRUCTURE, DataType.ERROR);

    public static DynamicStructDefinition getInstance() {
        return INSTANCE;
    }

    private DynamicStructDefinition() {
    }

    @Override
    public DataType getType() {
        return DataType.DYNAMIC_STRUCTURE;
    }

    @Override
    public List<Message> validate(DataValue value) {
        LinkedList<Message> result = new LinkedList<Message>();
        if (value == null) {
            result.add(MessageFactory.getMessage("vapi.data.dynamicstruct.validate.mismatch", VALID_DATA_TYPES.toString(), "null"));
        } else if (!VALID_DATA_TYPES.contains((Object)value.getType())) {
            result.add(MessageFactory.getMessage("vapi.data.dynamicstruct.validate.mismatch", VALID_DATA_TYPES.toString(), value.getType().toString()));
        }
        return result;
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

