/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DefinitionVisitor;
import com.vmware.vapi.data.OptionalValue;
import java.util.List;
import org.apache.commons.lang.Validate;

public class OptionalDefinition
extends DataDefinition {
    private DataDefinition elementType;

    public OptionalDefinition(DataDefinition elementType) {
        Validate.notNull((Object)elementType, (String)"Optional definition requires element definition.");
        this.elementType = elementType;
    }

    @Override
    public DataType getType() {
        return DataType.OPTIONAL;
    }

    public OptionalValue newInstance() {
        return new OptionalValue();
    }

    public DataDefinition getElementType() {
        return this.elementType;
    }

    @Override
    public List<Message> validate(DataValue value) {
        List<Message> subErrors;
        List<Message> errors = super.validate(value);
        if (!errors.isEmpty()) {
            return errors;
        }
        OptionalValue optVal = (OptionalValue)value;
        if (optVal.isSet() && !(subErrors = this.getElementType().validate(optVal.getValue())).isEmpty()) {
            errors.add(MessageFactory.getMessage("vapi.data.optional.validate", new String[0]));
            errors.addAll(subErrors);
        }
        return errors;
    }

    @Override
    public void completeValue(DataValue value) {
        if (value != null && value.getType() == DataType.OPTIONAL) {
            OptionalValue optValue = (OptionalValue)value;
            this.elementType.completeValue(optValue.getValue());
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OptionalDefinition)) {
            return false;
        }
        OptionalDefinition otherOptional = (OptionalDefinition)other;
        return this.elementType.equals(otherOptional.elementType);
    }

    public int hashCode() {
        return 17 + 31 * this.elementType.hashCode();
    }

    @Override
    public String toString() {
        return "Optional[" + this.elementType.toString() + "]";
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }
}

