/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.data;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.Message;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DefinitionVisitor;
import com.vmware.vapi.data.StructDefinition;
import java.util.List;
import org.apache.commons.lang.Validate;

public class StructRefDefinition
extends DataDefinition {
    private final String name;
    private StructDefinition structDefinition;

    public StructRefDefinition(String name) {
        Validate.notNull((Object)name);
        this.name = name;
    }

    public StructRefDefinition(StructDefinition structDefinition) {
        Validate.notNull((Object)structDefinition);
        this.name = structDefinition.getName();
        this.structDefinition = structDefinition;
    }

    public String getName() {
        return this.name;
    }

    public StructDefinition getTarget() {
        return this.structDefinition;
    }

    public void setTarget(StructDefinition structDefinition) {
        Validate.notNull((Object)structDefinition);
        if (this.structDefinition != null) {
            throw new CoreException(MessageFactory.getMessage("vapi.data.structref.already.resolved", this.name));
        }
        if (!this.name.equals(structDefinition.getName())) {
            throw new CoreException(MessageFactory.getMessage("vapi.data.structref.resolve.type.mismatch", this.name, structDefinition.getName()));
        }
        this.structDefinition = structDefinition;
    }

    @Override
    public DataType getType() {
        return DataType.STRUCTURE_REF;
    }

    @Override
    public void accept(DefinitionVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public List<Message> validate(DataValue value) {
        this.checkResolved();
        return this.structDefinition.validate(value);
    }

    @Override
    public void completeValue(DataValue value) {
        this.checkResolved();
        this.structDefinition.completeValue(value);
    }

    private void checkResolved() {
        if (this.structDefinition == null) {
            throw new CoreException(MessageFactory.getMessage("vapi.data.structref.not.resolved", this.name));
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof StructRefDefinition)) {
            return false;
        }
        StructRefDefinition other = (StructRefDefinition)obj;
        return this.name.equals(other.getName());
    }

    public int hashCode() {
        return 17 + 31 * this.name.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getName() + " {...}");
        return buf.toString();
    }
}

