/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.diagnostics;

import com.vmware.vapi.diagnostics.LogDiagnosticsConfigurator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;
import org.slf4j.MDC;

public final class Slf4jMDCLogConfigurator
implements LogDiagnosticsConfigurator {
    @Override
    public void configureContext(Map<String, String> diagCtx) {
        if (diagCtx == null) {
            return;
        }
        for (String key : diagCtx.keySet()) {
            MDC.put((String)key, (String)diagCtx.get(key));
        }
    }

    @Override
    public void cleanUpContext() {
        MDC.clear();
    }

    @Override
    public void cleanUpContext(Collection<String> keys) {
        Validate.notNull(keys);
        for (String k : keys) {
            MDC.remove((String)k);
        }
    }

    @Override
    public Map<String, String> getContext() {
        Map ctx = MDC.getCopyOfContextMap();
        if (ctx == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>(ctx);
        return result;
    }
}

