/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.convert.impl;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.data.ConstraintValidationException;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.internal.bindings.convert.PrimitiveConverter;
import com.vmware.vapi.internal.bindings.convert.impl.ConvertUtil;
import java.net.URI;
import java.net.URISyntaxException;

public final class JavaNetUriUriConverter
implements PrimitiveConverter<StringValue> {
    public URI fromValue(StringValue value) {
        String iriString = value.getValue();
        try {
            return new URI(iriString);
        }
        catch (URISyntaxException ex) {
            throw new ConstraintValidationException(MessageFactory.getMessage("vapi.bindings.typeconverter.uri.invalid.format", iriString), (Throwable)ex);
        }
    }

    @Override
    public StringValue toValue(Object primitiveBinding) {
        URI uri = ConvertUtil.narrowType(primitiveBinding, URI.class);
        return new StringValue(uri.toString());
    }
}

