/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.bindings.type;

import com.vmware.vapi.bindings.type.AnyErrorType;
import com.vmware.vapi.bindings.type.BinaryType;
import com.vmware.vapi.bindings.type.BooleanType;
import com.vmware.vapi.bindings.type.DateTimeType;
import com.vmware.vapi.bindings.type.DoubleType;
import com.vmware.vapi.bindings.type.DynamicStructType;
import com.vmware.vapi.bindings.type.EnumType;
import com.vmware.vapi.bindings.type.ErrorType;
import com.vmware.vapi.bindings.type.IdType;
import com.vmware.vapi.bindings.type.IntegerType;
import com.vmware.vapi.bindings.type.ListType;
import com.vmware.vapi.bindings.type.MapType;
import com.vmware.vapi.bindings.type.OpaqueType;
import com.vmware.vapi.bindings.type.OptionalType;
import com.vmware.vapi.bindings.type.SecretType;
import com.vmware.vapi.bindings.type.SetType;
import com.vmware.vapi.bindings.type.StringType;
import com.vmware.vapi.bindings.type.StructType;
import com.vmware.vapi.bindings.type.Type;
import com.vmware.vapi.bindings.type.TypeReference;
import com.vmware.vapi.bindings.type.TypeVisitor;
import com.vmware.vapi.bindings.type.UriType;
import com.vmware.vapi.bindings.type.VoidType;
import com.vmware.vapi.data.AnyErrorDefinition;
import com.vmware.vapi.data.BlobDefinition;
import com.vmware.vapi.data.BooleanDefinition;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DoubleDefinition;
import com.vmware.vapi.data.DynamicStructDefinition;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.IntegerDefinition;
import com.vmware.vapi.data.ListDefinition;
import com.vmware.vapi.data.OpaqueDefinition;
import com.vmware.vapi.data.OptionalDefinition;
import com.vmware.vapi.data.SecretDefinition;
import com.vmware.vapi.data.StringDefinition;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructRefDefinition;
import com.vmware.vapi.data.VoidDefinition;
import com.vmware.vapi.internal.data.ReferenceResolver;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.Validate;

public final class TypeUtil {
    private TypeUtil() {
    }

    public static DataDefinition toDataDefinition(Type type) {
        Validate.notNull((Object)type);
        ReferenceResolver ctx = new ReferenceResolver();
        HashSet<String> seenStructures = new HashSet<String>();
        DataDefinition def = DataDefinitionBuilder.toDataDefinition(type, ctx, seenStructures);
        ctx.resolveReferences();
        return def;
    }

    private static class DataDefinitionBuilder
    implements TypeVisitor {
        private final ReferenceResolver ctx;
        private final Set<String> seenStructures;
        private DataDefinition def;

        public DataDefinitionBuilder(ReferenceResolver ctx, Set<String> seenStructures) {
            this.ctx = ctx;
            this.seenStructures = seenStructures;
        }

        public DataDefinition getDefinition() {
            return this.def;
        }

        @Override
        public void visit(VoidType type) {
            this.def = VoidDefinition.getInstance();
        }

        @Override
        public void visit(IntegerType type) {
            this.def = IntegerDefinition.getInstance();
        }

        @Override
        public void visit(DoubleType type) {
            this.def = DoubleDefinition.getInstance();
        }

        @Override
        public void visit(StringType type) {
            this.def = StringDefinition.getInstance();
        }

        @Override
        public void visit(BooleanType type) {
            this.def = BooleanDefinition.getInstance();
        }

        @Override
        public void visit(BinaryType type) {
            this.def = BlobDefinition.getInstance();
        }

        @Override
        public void visit(DateTimeType type) {
            this.def = StringDefinition.getInstance();
        }

        @Override
        public void visit(UriType type) {
            this.def = StringDefinition.getInstance();
        }

        @Override
        public void visit(OptionalType type) {
            this.def = new OptionalDefinition(this.toDataDefinition(type.getElementType()));
        }

        @Override
        public void visit(ListType type) {
            this.def = new ListDefinition(this.toDataDefinition(type.getElementType()));
        }

        @Override
        public void visit(StructType type) {
            String structName = type.getName();
            if (this.seenStructures.contains(structName)) {
                if (this.ctx.isDefined(structName)) {
                    this.def = this.ctx.getDefinition(structName);
                } else {
                    StructRefDefinition structRef = new StructRefDefinition(structName);
                    this.ctx.addReference(structRef);
                    this.def = structRef;
                }
            } else {
                this.seenStructures.add(structName);
                HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
                for (String field : type.getFieldNames()) {
                    Type fieldType = type.getField(field);
                    DataDefinition fieldDef = this.toDataDefinition(fieldType);
                    fields.put(field, fieldDef);
                }
                StructDefinition structDef = new StructDefinition(structName, fields);
                this.ctx.addDefinition(structDef);
                this.def = structDef;
            }
        }

        @Override
        public void visit(OpaqueType type) {
            this.def = OpaqueDefinition.getInstance();
        }

        @Override
        public void visit(SecretType type) {
            this.def = SecretDefinition.getInstance();
        }

        @Override
        public void visit(TypeReference<? extends Type> type) {
            Type target = type.resolve();
            target.accept(this);
        }

        @Override
        public void visit(EnumType type) {
            this.def = StringDefinition.getInstance();
        }

        @Override
        public void visit(ErrorType type) {
            HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
            for (String field : type.getFieldNames()) {
                Type fieldType = type.getField(field);
                DataDefinition fieldDef = this.toDataDefinition(fieldType);
                fields.put(field, fieldDef);
            }
            this.def = new ErrorDefinition(type.getName(), fields);
        }

        @Override
        public void visit(SetType type) {
            this.def = new ListDefinition(this.toDataDefinition(type.getElementType()));
        }

        @Override
        public void visit(MapType type) {
            HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
            fields.put("key", this.toDataDefinition(type.getKeyType()));
            fields.put("value", this.toDataDefinition(type.getValueType()));
            this.def = new ListDefinition(new StructDefinition("map-entry", fields));
        }

        @Override
        public void visit(DynamicStructType type) {
            this.def = DynamicStructDefinition.getInstance();
        }

        @Override
        public void visit(IdType idType) {
            this.def = StringDefinition.getInstance();
        }

        @Override
        public void visit(AnyErrorType type) {
            this.def = AnyErrorDefinition.getInstance();
        }

        private DataDefinition toDataDefinition(Type type) {
            return DataDefinitionBuilder.toDataDefinition(type, this.ctx, this.seenStructures);
        }

        public static DataDefinition toDataDefinition(Type type, ReferenceResolver ctx, Set<String> seenStructures) {
            DataDefinitionBuilder elementDefBuilder = new DataDefinitionBuilder(ctx, seenStructures);
            type.accept(elementDefBuilder);
            return elementDefBuilder.getDefinition();
        }
    }
}

