/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.http.impl;

import com.vmware.vapi.internal.protocol.common.http.BinaryInput;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import org.apache.commons.lang.Validate;

public final class LengthFieldDeserializer {
    private static final Charset ASCII = Charset.forName("US-ASCII");
    private static final int HEX_RADIX = 16;
    private final int maxAllowedHexDigits;
    private final ByteArrayOutputStream hexDigits;
    private boolean done;
    private boolean expectLf;

    public LengthFieldDeserializer(int maxAllowedHexDigits) {
        Validate.isTrue((maxAllowedHexDigits > 0 ? 1 : 0) != 0);
        this.maxAllowedHexDigits = maxAllowedHexDigits;
        this.hexDigits = new ByteArrayOutputStream(maxAllowedHexDigits);
        this.done = false;
    }

    public Integer read(BinaryInput input) throws IOException {
        int b;
        if (this.done) {
            throw new IllegalStateException("Field already extracted. The deserializer can be used only for a single field.");
        }
        Integer result = null;
        while (result == null && (b = input.read()) != -2) {
            if (b == -1) {
                if (this.hexDigits.size() == 0) {
                    this.done = true;
                    break;
                }
                throw new IOException("Unexpected end of stream while reading frame length field.");
            }
            if (this.expectLf) {
                LengthFieldDeserializer.assertLf(b);
                this.expectLf = false;
                result = LengthFieldDeserializer.parseHex(this.hexDigits.toByteArray());
                this.done = true;
                continue;
            }
            if (b == 13) {
                if (this.hexDigits.size() > 0) {
                    this.expectLf = true;
                    continue;
                }
                throw new IOException("Length field contains no digits.");
            }
            this.assertHexDigit(b);
            this.hexDigits.write(b);
        }
        return result;
    }

    private static void assertLf(int b) throws IOException {
        if (b != 10) {
            throw new IOException("Expected line-feed ASCII character. Found " + b);
        }
    }

    private void assertHexDigit(int b) throws IOException {
        if (!LengthFieldDeserializer.isHexDigit((char)b)) {
            throw new IOException("Encountered invalid hex digit while reading frame length field: " + b);
        }
        if (this.hexDigits.size() > this.maxAllowedHexDigits) {
            throw new IOException("The length field is too large. It has more than " + this.maxAllowedHexDigits + " hex digits.");
        }
    }

    private static Integer parseHex(byte[] asciiHex) throws IOException {
        String hexString = new String(asciiHex, ASCII);
        Integer result = Integer.parseInt(hexString, 16);
        return result;
    }

    private static boolean isHexDigit(char c) {
        if ('0' <= c && c <= '9') {
            return true;
        }
        if ('a' <= c && c <= 'f') {
            return true;
        }
        return 'A' <= c && c <= 'F';
    }
}

