/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.common.json;

import com.vmware.vapi.CoreException;
import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.ExecutionContext;
import com.vmware.vapi.core.MethodResult;
import com.vmware.vapi.data.BlobValue;
import com.vmware.vapi.data.BooleanValue;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DoubleValue;
import com.vmware.vapi.data.ErrorValue;
import com.vmware.vapi.data.IntegerValue;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretValue;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidValue;
import com.vmware.vapi.internal.diagnostics.DiagnosticsKey;
import com.vmware.vapi.internal.dsig.json.CanonicalizationUtil;
import com.vmware.vapi.internal.protocol.common.json.JsonApiRequest;
import com.vmware.vapi.internal.protocol.common.json.JsonApiResponse;
import com.vmware.vapi.internal.protocol.common.json.JsonError;
import com.vmware.vapi.internal.protocol.common.json.JsonInvokeRequestParams2;
import com.vmware.vapi.internal.protocol.common.json.JsonSerializer;
import java.io.IOException;
import java.util.Collections;
import org.apache.commons.lang.time.StopWatch;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.codehaus.jackson.Version;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.module.SimpleModule;
import org.codehaus.jackson.map.ser.std.SerializerBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonMsgSerializer2
implements JsonSerializer {
    private static final String MSG_RESPONSE_SERIALIZER_TIME = "msgResponseSerializerTimer2";
    private static final Logger logger = LoggerFactory.getLogger(JsonMsgSerializer2.class);
    private static SimpleModule module = new SimpleModule("vAPI", new Version(0, 1, 0, "alpha"));
    private static final String METHOD_RESULT_OUTPUT = "output";
    private static final String METHOD_RESULT_ERROR = "error";
    private final ObjectMapper mapper = new ObjectMapper();

    public JsonMsgSerializer2() {
        this.mapper.registerModule((Module)module);
        DiagnosticsKey key = new DiagnosticsKey("JsonMsgSerializer2", new String[]{MSG_RESPONSE_SERIALIZER_TIME});
    }

    @Override
    public byte[] serialize(Object object) {
        StopWatch msgResponseDeserializerTimer = new StopWatch();
        msgResponseDeserializerTimer.start();
        try {
            byte[] byArray = this.mapper.writeValueAsBytes(object);
            return byArray;
        }
        catch (IOException e) {
            logger.error("Failed to serialize JSON request", (Throwable)e);
            throw JsonMsgSerializer2.toVapiCoreException(e);
        }
        finally {
            msgResponseDeserializerTimer.stop();
        }
    }

    public String serializeToString(Object object) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)module);
        try {
            return mapper.writeValueAsString(object);
        }
        catch (IOException e) {
            logger.error("Failed to serialize JSON request", (Throwable)e);
            throw JsonMsgSerializer2.toVapiCoreException(e);
        }
    }

    private static CoreException toVapiCoreException(Exception ex) {
        return new CoreException(MessageFactory.getMessage("vapi.json.serialize.ioerror", ex.getMessage()), (Throwable)ex);
    }

    static {
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new VoidValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new BooleanValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new IntegerValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new DoubleValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new StringValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new BlobValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new OptionalValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new ListValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new StructValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new SecretValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new BooleanValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new ErrorValueSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new MethodResultSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new AppContextSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new ApiRequestSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new ApiResponseSerializer());
        module.addSerializer((org.codehaus.jackson.map.JsonSerializer)new JsonErrorSerializer());
    }

    private static class JsonErrorSerializer
    extends SerializerBase<JsonError> {
        public JsonErrorSerializer() {
            super(JsonError.class);
        }

        public void serialize(JsonError error, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeNumberField("code", error.getCode());
            jgen.writeStringField("message", error.getMessage());
            if (error.getData() != null) {
                jgen.writeStringField("data", error.getData());
            }
            jgen.writeEndObject();
        }
    }

    private static class ApiResponseSerializer
    extends SerializerBase<JsonApiResponse> {
        public ApiResponseSerializer() {
            super(JsonApiResponse.class);
        }

        public void serialize(JsonApiResponse response, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("jsonrpc", "2.0");
            jgen.writeStringField("id", response.getId());
            jgen.writeObjectField("result", (Object)response.getResult());
        }
    }

    private static class ApiRequestSerializer
    extends SerializerBase<JsonApiRequest> {
        public ApiRequestSerializer() {
            super(JsonApiRequest.class);
        }

        public void serialize(JsonApiRequest request, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField("jsonrpc", "2.0");
            jgen.writeStringField("id", request.getId());
            jgen.writeStringField("method", request.getMethod());
            JsonInvokeRequestParams2 params = (JsonInvokeRequestParams2)request.getParams();
            jgen.writeFieldName("params");
            jgen.writeStartObject();
            jgen.writeStringField("serviceId", params.getServiceId());
            jgen.writeStringField("operationId", params.getOperationId());
            jgen.writeObjectField("ctx", (Object)params.getCtx());
            jgen.writeObjectField("input", (Object)params.getInput());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    private static class AppContextSerializer
    extends SerializerBase<ExecutionContext> {
        private static final String APP_CTX = "appCtx";

        public AppContextSerializer() {
            super(ExecutionContext.class);
        }

        public void serialize(ExecutionContext ctx, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            ExecutionContext.ApplicationData additionalRequestData = ctx.retrieveApplicationData();
            if (additionalRequestData != null) {
                provider.defaultSerializeField(APP_CTX, additionalRequestData.getAllProperties(), jgen);
            } else {
                provider.defaultSerializeField(APP_CTX, Collections.emptyMap(), jgen);
            }
            jgen.writeEndObject();
        }
    }

    private static class MethodResultSerializer
    extends SerializerBase<MethodResult> {
        public MethodResultSerializer() {
            super(MethodResult.class);
        }

        public void serialize(MethodResult methodResult, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            DataValue output = methodResult.getOutput();
            ErrorValue error = methodResult.getError();
            jgen.writeStartObject();
            if (null != output) {
                provider.defaultSerializeField(JsonMsgSerializer2.METHOD_RESULT_OUTPUT, (Object)output, jgen);
            } else if (null != error) {
                provider.defaultSerializeField(JsonMsgSerializer2.METHOD_RESULT_ERROR, (Object)error, jgen);
            }
            jgen.writeEndObject();
        }
    }

    private static class SecretValueSerializer
    extends SerializerBase<SecretValue> {
        public SecretValueSerializer() {
            super(SecretValue.class);
        }

        public void serialize(SecretValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeStringField(value.getType().getValue(), new String(value.getValue()));
            jgen.writeEndObject();
        }
    }

    private static class ErrorValueSerializer
    extends SerializerBase<ErrorValue> {
        public ErrorValueSerializer() {
            super(ErrorValue.class);
        }

        public void serialize(ErrorValue error, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(error.getType().getValue());
            jgen.writeObjectField(error.getName(), error.getFields());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    private static class StructValueSerializer
    extends SerializerBase<StructValue> {
        public StructValueSerializer() {
            super(StructValue.class);
        }

        public void serialize(StructValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeObjectFieldStart(value.getType().getValue());
            jgen.writeObjectField(value.getName(), value.getFields());
            jgen.writeEndObject();
            jgen.writeEndObject();
        }
    }

    private static class ListValueSerializer
    extends SerializerBase<ListValue> {
        public ListValueSerializer() {
            super(ListValue.class);
        }

        public void serialize(ListValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartArray();
            for (DataValue serializeValue : value.getList()) {
                jgen.writeObject((Object)serializeValue);
            }
            jgen.writeEndArray();
        }
    }

    private static class OptionalValueSerializer
    extends SerializerBase<OptionalValue> {
        public OptionalValueSerializer() {
            super(OptionalValue.class);
        }

        public void serialize(OptionalValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            jgen.writeFieldName(value.getType().getValue());
            if (value.isSet()) {
                jgen.writeObject((Object)value.getValue());
            } else {
                jgen.writeNull();
            }
            jgen.writeEndObject();
        }
    }

    private static class BlobValueSerializer
    extends SerializerBase<BlobValue> {
        public BlobValueSerializer() {
            super(BlobValue.class);
        }

        public void serialize(BlobValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeStartObject();
            provider.defaultSerializeField(value.getType().getValue(), (Object)value.getValue(), jgen);
            jgen.writeEndObject();
        }
    }

    private static class StringValueSerializer
    extends SerializerBase<StringValue> {
        public StringValueSerializer() {
            super(StringValue.class);
        }

        public void serialize(StringValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeString(value.getValue());
        }
    }

    private static class DoubleValueSerializer
    extends SerializerBase<DoubleValue> {
        public DoubleValueSerializer() {
            super(DoubleValue.class);
        }

        public void serialize(DoubleValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(CanonicalizationUtil.canonicalizeDouble(value.getValue()));
        }
    }

    private static class IntegerValueSerializer
    extends SerializerBase<IntegerValue> {
        public IntegerValueSerializer() {
            super(IntegerValue.class);
        }

        public void serialize(IntegerValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNumber(value.getValue());
        }
    }

    private static class BooleanValueSerializer
    extends SerializerBase<BooleanValue> {
        public BooleanValueSerializer() {
            super(BooleanValue.class);
        }

        public void serialize(BooleanValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeBoolean(value.getValue());
        }
    }

    private static class VoidValueSerializer
    extends SerializerBase<VoidValue> {
        public VoidValueSerializer() {
            super(VoidValue.class);
        }

        public void serialize(VoidValue value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeNull();
        }
    }
}

